% Plot results generated by batch_initArrRate_stationary.m

initArrRateSet = [1 2 3 4 5 6];

string_matrix = [];
for i = 1:length(initArrRateSet)
    initArrRate = i;
    string_matrix = strvcat(string_matrix,sprintf('Init. Arr. Rate = %d packets/s',initArrRate*100));
end
line_type_matrix = strvcat('bh','go','rx','c+','ms','kv','yd');

figure;
set(gca,'FontSize',10);
for i = 1:length(initArrRateSet) % Initialized deterministic arrival, stationary dynamics
    initArrRate = i;
    inmatStationary = ['results_PDSlearning_initArrRate' num2str(initArrRate) '_stationary.mat']
    load(inmatStationary,'sim','B');
    
    legInitArrRate(initArrRate) = ...
        plot(mean(sim.holdingCostPoints)*B,mean(sim.powerPoints)*1000,line_type_matrix(i,:),'markerSize',12,'LineWidth',2); hold on;
end

for i = initArrRateSet % Initialized deterministic arrival, nonstationary dynamics
    initArrRate = i;
    inmatNonstationary = ['results_PDSlearning_initArrRate' num2str(initArrRate) '_nonstationary.mat']
    load(inmatNonstationary,'sim');
    
    plot(mean(sim.holdingCostPoints)*B,mean(sim.powerPoints)*1000,line_type_matrix(i,:),'markerSize',12,'LineWidth',2); hold on;
end

load ./results_allerton/results_PDSlearning_arr2_constraint4_virtualFreq25.mat sim % Initialized uniform arrival, stationary dynamics
uniformStationary = plot(mean(sim.holdingCostPoints)*B,mean(sim.powerPoints)*1000,line_type_matrix(7,:),'markerSize',12,'LineWidth',2);

xlabel('Holding cost (packets)'); ylabel('Power (mW)');
% title('Power-Delay Performance for Different Initialized Arrival Rates');
legend([legInitArrRate, uniformStationary],strvcat(string_matrix,'Initialized Arrival Rate = Uniform'));
axis([3.90 4.25 180 240]);
