package simulate.units;

public final class Picosecond extends Unit.Time {

  /**
   * Convenience instance of this unit to permit unit to be assigned
   * without creating a new instance of it each time
   */
    public static final Picosecond UNIT = new Picosecond();
  
  /**
   * Conversion factor to/from simulation units
   */
    static final double to = 1.0; 
    static final double from = 1.0/to;
    
    public double toSim(double x) {return to*x;}
    public double fromSim(double x) {return from*x;}
    
    public String toString() {return "picoseconds";}
    public String symbol() {return "ps";};  
}