package simulate.units;
import simulate.Constants;

public final class Kelvin extends Unit.Temperature {

  /**
   * Convenience instance of this unit to permit unit to be assigned
   * without creating a new instance of it each time
   */
    public static final Kelvin UNIT = new Kelvin();
  
  /**
   * Conversion factor to/from simulation units
   */
    static final double to = Constants.BOLTZMANN_K; 
    static final double from = 1.0/to;
    
    public double toSim(double x) {return to*x;}
    public double fromSim(double x) {return from*x;}
    
    public String toString() {return "Kelvins";}
    public String symbol() {return "K";};
}