package simulate.units;
import simulate.Constants;

public final class Esu extends Unit.Charge {

  /**
   * Convenience instance of this unit to permit unit to be assigned
   * without creating a new instance of it each time
   */
    public static final Esu UNIT = new Esu();
    
  /**
   * Conversion factor to/from simulation units
   */
    static final double to = Math.sqrt(Constants.AVOGADRO*1e24*1e-24); //7.76e11; conversion from (g-cm^3/s^2)^(1/2) to (amu-A^3/ps^2)^(1/2)
    static final double from = 1.0/to;
    
    public double toSim(double x) {return to*x;}
    public double fromSim(double x) {return from*x;}
    
    public String toString() {return "electrostatic units";}
    public String symbol() {return "esu";};
}