package simulate.units;
import simulate.Constants;

public final class Bar extends Unit.Pressure implements Unit.D3 {

  /**
   * Convenience instance of this unit to permit unit to be assigned
   * without creating a new instance of it each time
   */
    public static final Bar UNIT = new Bar();
  
  /**
   * Conversion factor to/from simulation units
   */
    static final double to = Constants.AVOGADRO*1000.*1e-10*1e-24; //6.022e-3; conversion from 10^5 kg/(m-s^2) to amu/(A-ps^2)
    static final double from = 1.0/to;
    
    public double toSim(double x) {return to*x;}
    public double fromSim(double x) {return from*x;}
    
    public String toString() {return "bars";}
    public String symbol() {return "bar";};
}