package simulate.electrostatics;

import simulate.units.*;
import simulate.Space;
import java.awt.Graphics;

    /**
     * ElectroType for a simple Coulombic charge (monopole) 
     * Default units are electron charge
     */
public final class Monopole extends ElectroType {
    private double z;  //coulomb charge
    private Unit.Charge zUnit;
            
    public Monopole() {
        setZ(0.0,Electron.UNIT);
    }
    public Monopole(double z) {
        setZ(z, Electron.UNIT);
    }
    public final void setZ(double t, Unit.Charge u) {
        zUnit = u;
        setZ(t);
    }
    public void setZ(double t) {z = zUnit.toSim(t);}
    public final double getZ() {return zUnit.fromSim(z);}
    public final double z() {return z;}
    public final void setZUnit(Unit.Charge u) {zUnit = u;}
    public Unit.Charge getZUnit() {return zUnit;}
    
    public void draw(Graphics g, int origin[], double scale, Space.Vector r) {}
}
