package simulate.electrostatics;

import simulate.units.*;
import simulate.*;
import java.awt.*;

//draw method is specific to 2D

    /**
     * ElectroType for a point dipole 
     * Default units are Debyes
     */
public final class Dipole extends ElectroType {
    private double mu;  //magnitude
    private final Space.Vector e; //direction
    private Unit.Dipole muUnit;
            
    public Dipole() {
        e = Simulation.space().makeVector();
        initializeE();
        setMu(0.0,Debye.UNIT);
    }
    public Dipole(double mu) {
        e = Simulation.space().makeVector();
        initializeE();
        setMu(mu, Debye.UNIT);
    }
    
    private void initializeE() {
        e.E(0.0);   //zero vector
        e.E(0,1.0); //set first component to unity
    }
    
    public Space.Vector e() {return e;}
    
    public final void setMu(double m, Unit.Dipole u) {
        muUnit = u;
        setMu(m);
    }
    public void setMu(double t) {mu = muUnit.toSim(t);}
    public final double getMu() {return muUnit.fromSim(mu);}
    public final double mu() {return mu;}
    public final void setMuUnit(Unit.Dipole u) {muUnit = u;}
    public Unit.Dipole getMuUnit() {return muUnit;}
    
    
    public void draw(Graphics g, int origin[], double scale, Space.Vector r) {
        double length = scale * Unit.Dipole.Sim.UNIT.toPixels(mu);
        int circleRadius = (int)(0.2*length);
        int x0 = origin[0] + (int)Unit.Length.Sim.UNIT.toPixels(scale*r.component(0));
        int y0 = origin[1] + (int)Unit.Length.Sim.UNIT.toPixels(scale*r.component(1));
        int xa = (int)(x0 - 0.5*length*e.component(0));
        int ya = (int)(y0 - 0.5*length*e.component(1));
        int xb = (int)(x0 + 0.5*length*e.component(0));
        int yb = (int)(y0 + 0.5*length*e.component(1));
        g.setColor(Color.black);
        g.drawLine(xa, ya, xb, yb);
        g.setColor(Color.green);
        xb -= circleRadius*(1+e.component(0));
        yb -= circleRadius*(1+e.component(1));
        g.fillOval(xb, yb, 2*circleRadius, 2*circleRadius);
    }
}
