package simulate;
import java.awt.*;

/**
 * Species in which molecules are made of arbitrary number of disks (same number for all molecules, though) 
 * with each disk having the same mass and size (same type).
 */
public class SpeciesDisks extends Species {

//  The atomType is not declared final here becuase it makes setting up the constructors easier,
//  but effectively it cannot be changed once initialized; the instance is passed to the atoms, where
//  it is declared final
//  Note that the parameters of the type can be changed; only the instance of it is frozen once the atoms are made
//    (this is the same behavior as declaring it final)
    public AtomType.Disk protoType;
              
    public SpeciesDisks() {
        super();
        setAtomsPerMolecule(1);
        if(Simulation.D == 1) {
            protoType = new AtomType.Rod(Default.ATOM_MASS,Default.ATOM_COLOR,Default.ATOM_SIZE);
        }
        else {
            protoType = new AtomType.Disk(Default.ATOM_MASS,Default.ATOM_COLOR,Default.ATOM_SIZE);
        }
        colorScheme = new ColorSchemeByType();
        moleculeConfiguration = new Molecule.Configuration.Linear();
        setNMolecules(Default.MOLECULE_COUNT);
        Simulation.register(this);
        
//        this.add(new ConfigurationMoleculeLinear());
    }
              
    public SpeciesDisks(int nM, int nA) {
        this(nM, nA, new AtomType.Disk(Default.ATOM_MASS, Default.ATOM_COLOR, Default.ATOM_SIZE));
    }
              
    public SpeciesDisks(int nM, int nA, AtomType.Disk type) {
        protoType = type;
        atomsPerMolecule = nA;
        setNMolecules(nM);
            
        colorScheme = new ColorSchemeByType();
        this.add(new Molecule.Configuration.Linear());
    }
    
            
    protected Molecule makeMolecule(Phase phase) {
        return new Molecule(this, phase, protoType, atomsPerMolecule);
    } 
              
    // Exposed Properties
    public final double getMass() {return protoType.mass();}
    public final void setMass(double mass) {protoType.setMass(mass);}
                
    public final double getDiameter() {return protoType.diameter();}
    public void setDiameter(double d) {protoType.setDiameter(d);}
                    
    public final Color getColor() {return protoType.color();}
    public final void setColor(Color c) {protoType.setColor(c);}
}


