package simulate; 
import java.awt.Component;

/**
 * Two-molecule, inter-molecular potential, defining all interatomic potentials of two different molecules.
 * All molecules of the two associated species (set by speciesIndex) have intermolecular interactions 
 * as defined here.
 */
public abstract class Potential2 extends Component implements Simulation.Element {

/**
 * Index of one of the species
 *
 * @see Species#speciesIndex
 */
  int species1Index;
/**
 * Index of one of the species
 *
 * @see Species#speciesIndex
 */ 
  int species2Index;

/**
 * Range of potential; molecules separated by more than this amount do not interact
 * Enforcement of cutoff is responsibility of subclasses
 */
  double potentialCutoff;

  public Potential2() {
    species1Index = species2Index = 0;
    Simulation.register(this);
  }

 /**
  * Returns the inter-atomic potential for the two given atoms
  * In many cases, the same potential governs interactions of all atoms of two molecules.
  */
  public abstract Potential getPotential(Atom a1, Atom a2);
 
 /**
  * Accessor method for potentialCutoff
  * @see #potentialCutoff
  */
  public final void setPotentialCutoff(double d) {
    potentialCutoff = d;
  }
  
 /**
  * Accessor method for species index
  * 
  * @see Species#speciesIndex
  */
  public int getSpecies1Index() {return this.species1Index;}  
 /**
  * Accessor method for species index
  * 
  * @see Species#speciesIndex
  */
  public void setSpecies1Index(int index) {this.species1Index = index;}
  
 /**
  * Accessor method for species index
  * 
  * @see Species#speciesIndex
  */
  public int getSpecies2Index() {return this.species2Index;}
 /**
  * Accessor method for species index
  * 
  * @see Species#speciesIndex
  */
  public void setSpecies2Index(int index) {this.species2Index = index;}
}


