package simulate;
import java.awt.Component;

/**
 * One-molecule, intra-molecular potential, defining all interatomic potentials within a molecule.
 * All molecules of the associated species (set by speciesIndex) have intramolecular interactions 
 * as defined here.
 */
 
 public abstract class Potential1 extends Component implements Simulation.Element {

/**
 * Index of the species that has its intramolecular interactions defined here
 *
 * @see Species#speciesIndex
 */
  int speciesIndex;

  public Potential1() {
    Simulation.register(this);
    speciesIndex = 0;
  }
  
  /**
   * Returns the interatomic potential between the two given atoms.
   * Both atoms should be part of the same molecule
   */
  public abstract Potential getPotential(Atom a1, Atom a2);
  
  /**
   * Accessor method for the speciesIndex, which defines the species that this potential describes
   */
  public final int getSpeciesIndex() {return this.speciesIndex;}  
  /**
   * Accessor method for the speciesIndex, which defines the species that this potential describes
   */
  public final void setSpeciesIndex(int index) {this.speciesIndex = index;}
}


