package simulate;
import simulate.units.*;

public class P2SquareWell extends Potential2 {

  private double coreDiameter;
  private Unit.Length coreDiameterUnit;
  private double epsilon;
  private Unit.Energy epsilonUnit;
  private PotentialSquareWell onlyPotential;
  private double lambda = 1.5;

  public P2SquareWell() {
    super();
    setCoreDiameter(Default.ATOM_SIZE, Default.ATOM_SIZE_UNIT);
    setEpsilon(Default.POTENTIAL_WELL, Default.POTENTIAL_WELL_UNIT);
    setLambda(lambda);  //set potentialCutoff, etc.
    onlyPotential = new PotentialSquareWell(coreDiameter,lambda,epsilon);
  }
    
  public final Potential getPotential(Atom a1, Atom a2) {return onlyPotential;}
  
  // CoreDiameter and its units
  public final void setCoreDiameter(double d, Unit.Length u) {
    coreDiameterUnit = u;
    setCoreDiameter(d);
  }
  public final void setCoreDiameter(double d) {
    coreDiameter = coreDiameterUnit.toSim(d);
    setPotentialCutoff(coreDiameter*lambda);
    if(onlyPotential != null) onlyPotential.setCoreDiameter(coreDiameter);
  }
  public final double getCoreDiameter() {return coreDiameterUnit.fromSim(coreDiameter);}
  public final double coreDiameter() {return coreDiameter;}
  public final void setCoreDiameterUnit(Unit.Length u) {coreDiameterUnit = u;}
  public Unit.Length getCoreDiameterUnit() {return coreDiameterUnit;}
  
  //Well-width multiplier lambda
  public final double getLambda() {return lambda;}
  public final void setLambda(double lam) {
    lambda = lam;
    setPotentialCutoff(coreDiameter*lambda);
    if(onlyPotential != null) onlyPotential.setLambda(lambda);
  }
  
  // Epsilon and its units
  public final void setEpsilon(double eps, Unit.Energy u) {
    epsilonUnit = u;
    setEpsilon(eps);
  }
  public final void setEpsilon(double eps) {
    epsilon = epsilonUnit.toSim(eps);
    if(onlyPotential != null) onlyPotential.setEpsilon(epsilon);
  }
  public final double getEpsilon() {return epsilonUnit.fromSim(epsilon);}
  public final double epsilon() {return epsilon;}
  public final void setEpsilonUnit(Unit.Energy u) {epsilonUnit = u;}
  public Unit.Energy getEpsilonUnit() {return epsilonUnit;}
}


