package simulate;

public class P2DiskWall extends Potential2 {

  private double collisionDiameter;
  private PotentialHardDiskWall onlyPotential;

  public P2DiskWall() {
    super();
    collisionDiameter = Default.ATOM_SIZE;
    onlyPotential = new PotentialHardDiskWall(collisionDiameter);
    setCollisionDiameter(collisionDiameter);   
  }
  
  public final Potential getPotential(Atom a1, Atom a2) {return onlyPotential;}
  
  public final double getCollisionDiameter() {return collisionDiameter;}
  public final void setCollisionDiameter(double d) {
    collisionDiameter = d;
    onlyPotential.setCollisionDiameter(d);
    setPotentialCutoff(d);
  }
}


