package simulate;

/**
 * Meter for measurement of pressure by averaging hard-particle collision dynamics
 * Relies on pAccumulator in IntegratorHard.Agent for measurement
 * Ignores updateInterval
 */
public class MeterPressure extends Meter
{
    private double timeSum = 0.0;

    public MeterPressure()
    {
        super();
        setLabel("Pressure");
    }
    
    public void intervalAction(Integrator.IntervalEvent evt) {
        IntegratorMD integrator = (IntegratorMD)evt.getSource();
        timeSum += integrator.timeStep * integrator.interval;
        updateSums();}

    public double currentValue()
    {
        double flux=0.0;
        int count = 0;                                                           //originally written to perform average for a single species
        for(Species.Agent s=phase.firstSpecies(); s!=null; s=s.nextSpecies()) {  //since now summing over all atoms, would be better to do that directly and remove species loop
            for(Atom a=s.firstAtom(); a!=s.terminationAtom(); a=a.nextAtom()) {
                if(a.ia instanceof IntegratorHard.Agent) {
                    IntegratorHard.Agent ia = (IntegratorHard.Agent)a.ia;
                    flux = 0.5*ia.pAccumulator/timeSum;
                    ia.pAccumulator = 0.0;
                    count++;
                }//else handle pressure for soft potential?
            }  
            timeSum = 0.0;
            flux /= count;   //count should be total area instead of number of atoms
        }
        return flux;
    }
    
}