package simulate;

/**
 * Meter for the total kinetic energy in a phase
 * Computes total KE by summing values of KE returned by every atom in the phase
 */
public class MeterKineticEnergy extends simulate.Meter
{
    Atom.Iterator atomIterator;
    
    public MeterKineticEnergy()
    {
        super();
        setLabel("Kinetic Energy");
    }

    public void setPhase(Phase p) {
        super.setPhase(p);
        atomIterator = p.iteratorFactory().makeAtomIteratorUp();
    }
    
    public double currentValue()
    {
        double ke = 0.0;
        atomIterator.reset();
        while(atomIterator.hasNext()) {    //consider doing this with an allAtoms call
            ke += atomIterator.next().kineticEnergy();
        }
        return ke;
    }
}