package simulate;

/**
 * Meter that keeps track of the number of intervalEvents fired by an integrator
 * More precisely, currentValue method returns number of events received divided by updateInterval, 
 * which is set to 1 by default
 * Methods average and error are meaningless for this integrator, and return Not-a-Number
 */

public class MeterCycles extends Meter
{
    private int count = 0;
    
    public MeterCycles()
    {
        super();
        setLabel("Cycles");
        setUpdateInterval(1);
    }
    /**
     * Increments the counter.  Normally called by intervalAction method defined in superclass
     */
    public void updateSums() {count++;}
    /**
     * Resets counter to zero
     */
    public void reset() {count = 0;}
    /**
     * Returns Not-a-Number
     */
    public double average() {return Double.NaN;}
    /**
     * Returns Not-a-Number
     */
    public double error() {return Double.NaN;}
    
    /**
     * Returns the number of interval events received, divided by updateInterval
     */
    public double currentValue()
    {
        return (double)count;  
    }
}