package simulate;

import simulate.*;
import java.awt.*;
import java.util.Observer;
import java.util.Observable;

// Writes current values of all meters to console

public class DisplayToConsole extends simulate.Display
{
    Meter[] meter;
    int nMeters = 0;
        
    public DisplayToConsole()
    {
        super();
        if(meter == null) meter = new Meter[0];
    }
        
    public void doUpdate() {
        for(int i=0; i<nMeters; i++) {
            System.out.println(meter[i].getLabel() + " " + meter[i].currentValue());
        }
        System.out.println();
    }
        
    public void addMeter(Meter m) {
        if(meter == null) meter = new Meter[0];
        nMeters++;
        Meter[] temp = new Meter[nMeters];
        for(int i=0; i<meter.length; i++) {temp[i] = meter[i];}
        temp[nMeters-1] = m;
        meter = temp;
    }
            
    public void setPhase(Phase p) {
        super.setPhase(p);
        p.meterManager().addObserver(new Observer() {
            public void update(Observable mgr, Object obj) {
                if(obj instanceof Meter) DisplayToConsole.this.addMeter((Meter)obj);  //don't want to add instance of MeterFunction
            }
        });
    }
        
    public void doPaint(Graphics g) {
    }
        
//    public void paint(Graphics g) {
//    createOffScreen();
//    doPaint(g);
//    }
}