package simulate;

import java.awt.Color;
import simulate.units.*;

public final class Default {
    
    public static final double ATOM_SIZE = 3.0;
    public static final Unit.Length ATOM_SIZE_UNIT = Angstrom.UNIT;
    
    public static final double ATOM_MASS = 40.0;
    public static final Unit.Mass ATOM_MASS_UNIT = Amu.UNIT;
    
    public static final Color ATOM_COLOR = Color.black;
    
    public static final int MOLECULE_COUNT = 20;
    
    public static final double BOX_SIZE = 30.0;
    public static final Unit.Length BOX_SIZE_UNIT = Angstrom.UNIT;
    
    public static final double TEMPERATURE = 300.;
    public static final Unit.Temperature TEMPERATURE_UNIT = Kelvin.UNIT;
    
    public static final double PRESSURE = 1.0;
    public static final Unit.Pressure PRESSURE_UNIT = Bar.UNIT;
    
    public static final double POTENTIAL_WELL = 300.;
    public static final Unit.Energy POTENTIAL_WELL_UNIT = Kelvin.UNIT;
    
    public static final double TIME_STEP = 0.05;
    public static final Unit.Time TIME_STEP_UNIT = Picosecond.UNIT;
    
}