package simulate;

import java.awt.Component;
import java.awt.Button;
import java.awt.Color;
import java.awt.Container;
import java.awt.event.*;
import java.util.*;

public class Controller extends Container implements Simulation.Element, Runnable {

    protected final LinkedList integrators = new LinkedList();
    Thread runner;
    private boolean initialized = false;
    private boolean autoStart = false;
    private int maxSteps;

    public Controller() {
        maxSteps = Integer.MAX_VALUE;
        Simulation.register(this);
    }
                      
    public void reset() {}

    public void add(Integrator i) {
        integrators.add(i);
        i.setController(this);
        i.setMaxSteps(maxSteps);
        if(autoStart) i.start();
    }
    
    public LinkedList integrators() {return integrators;}
                      
    public void setAutoStart(boolean b) {autoStart = b;}
    public boolean getAutoStart() {return autoStart;}
                                                    
    public int getMaxSteps() {return maxSteps;}
    public void setMaxSteps(int m) {
        maxSteps = m;
        for(java.util.Iterator iter=integrators.iterator(); iter.hasNext(); ) {
            ((Integrator)iter.next()).setMaxSteps(m);
        }
    }
                    
    public void start() {
        runner = new Thread(this);
        runner.start();
    }
                    

    public void run() {
        for(java.util.Iterator iter=integrators.iterator(); iter.hasNext(); ) {
            ((Integrator)iter.next()).start();
        }
    }
                    
    public class Button extends Device implements ActionListener {
            
        java.awt.Button button;
        private boolean firstClick = true;
        private boolean running = false;

        public Button() {
            super();
            if(button == null) button = new java.awt.Button("Start");
            button.setBounds(0,0,60,40);
	        button.setBackground(new Color(12632256));
            autoStart = false;
            button.addActionListener(this);
        }
              
        public void reset() {
            firstClick = true;
            button.setLabel("Start");
        }

        public void clickButton() {  //method to mimic action of button click
            actionPerformed(new ActionEvent(button,0,""));
        }
        public void clickForPause() {  //clicks button to pause if not already paused
            if(running) clickButton();
        }
              
        public void setButtonColor(Color c) {button.setBackground(c);}
        public Color getButtonColor() {return button.getBackground();}
              
        public void setButtonTextColor(Color c) {button.setForeground(c);}
        public Color getButtonTextColor() {return button.getForeground();}
              
        public void actionPerformed(ActionEvent evt) {
            if(firstClick) {
                start();
                running = true;
                firstClick = false;
                button.setLabel("Pause");
            }
            else if(running) {
                running = false;
                for(java.util.Iterator iter=integrators.iterator(); iter.hasNext(); ) {
                    ((Integrator)iter.next()).pause();
                }
                button.setLabel("Continue");
            }
            else {
                for(java.util.Iterator iter=integrators.iterator(); iter.hasNext(); ) {
                    ((Integrator)iter.next()).unPause();
                }
                running = true;
	            button.setLabel("Pause");
	        }
	    }
            
        public Component graphic(Object obj) {
            if(button == null) button = new java.awt.Button("Start");
            return button;
        }
            
    }//end of Controller.Button
}


