package simulate.units;

public abstract class UnitSystem {
    
    public abstract Unit.Mass mass();
    public abstract Unit.Length length();
    public abstract Unit.Time time();
    public abstract Unit.Charge charge();
    public abstract Unit.Energy energy();
    public abstract Unit.Temperature temperature();
    public abstract Unit.Pressure pressure(int D);
    public abstract Unit.Volume volume(int D);
    
    public Unit.Pressure pressure() {return pressure(2);}
    public Unit.Volume volume() {return volume(2);}


    public static class Sim extends UnitSystem {
        
        public Unit.Mass mass() {return Amu.UNIT;}
        public Unit.Length length() {return Angstrom.UNIT;}
        public Unit.Time time() {return Picosecond.UNIT;}
        public Unit.Charge charge() {return Unit.Charge.Sim.UNIT;}
        public Unit.Dipole dipole() {return Unit.Dipole.Sim.UNIT;}
        public Unit.Energy energy() {return Unit.Energy.Sim.UNIT;}
        public Unit.Temperature temperature() {return Unit.Temperature.Sim.UNIT;}
        public Unit.Pressure pressure(int D) {return (D==2) ? Unit.Pressure2D.Sim.UNIT : Unit.Pressure.Sim.UNIT;}
        public Unit.Volume volume(int D) {return (D==2) ? Unit.Volume2D.Sim.UNIT : Unit.Volume.Sim.UNIT;}
        
    }
    
    //will also define MKS, CGS, atomic, English unit systems
}