package simulate.units;
import simulate.Constants;

public final class Joule extends Unit.Energy {

  /**
   * Convenience instance of this unit to permit unit to be assigned
   * without creating a new instance of it each time
   */
    public static final Joule UNIT = new Joule();
    
  /**
   * Conversion factor to/from simulation units
   */
    static final double to = Constants.AVOGADRO*1000.*1e20*1e-24; //6.022e22; conversion from kg-m^2/s^2 to amu-A^2/ps^2
    static final double from = 1.0/to;
    
    public double toSim(double x) {return to*x;}
    public double fromSim(double x) {return from*x;}
    
    public String toString() {return "Joules";}
    public String symbol() {return "J";};
}