package simulate.units;
import simulate.Constants;

public final class Debye extends Unit.Dipole {

  /**
   * Convenience instance of this unit to permit unit to be assigned
   * without creating a new instance of it each time
   */
    public static final Debye UNIT = new Debye();
    
  /**
   * Conversion factor to/from simulation units
   */
    static final double to = Math.sqrt(Constants.AVOGADRO*1e40*1e-24)*1e-18; //77.6; conversion from (g-cm^5/s^2)^(1/2) to 10^-18 * (amu-A^5/ps^2)^(1/2) (Debye)
    static final double from = 1.0/to;
    
    public double toSim(double x) {return to*x;}
    public double fromSim(double x) {return from*x;}
    
    public String toString() {return "Debyes";}
    public String symbol() {return "D";};
}