package simulate.units;
import simulate.Constants;

public final class Angstrom extends Unit.Length {

  /**
   * Convenience instance of this unit to permit unit to be assigned
   * without creating a new instance of it each time
   */
    public static final Angstrom UNIT = new Angstrom();
  
  /**
   * Conversion factor to/from simulation units
   */
    static final double to = 1.0; 
    static final double from = 1.0/to;
    
    public double toSim(double x) {return to*x;}
    public double fromSim(double x) {return from*x;}
    
    public String toString() {return "Angstroms";}
    public String symbol() {return "\u00c5";};  //unicode for the Angstrom symbol
}