package simulate;

/**
 * Methods needed to describe the behavior of a soft potential.  
 * A soft potential describes non-impulsive interactions, in which the energy at all points
 * has smooth, analytic behavior with no discontinuities.  
 *
 * @see PotentialHard
 */
public interface PotentialSoft extends Potential {
    
    /**
     * Force exerted by one atom on the other.
     * By convention, this gives the change in the potential energy as atom1
     * of the pair is displaced as atom2 is held fixed, i.e., it is the
     * gradient of the potential with respect to the position of atom1
     *
     * @return the vector force that atom2 of the pair exerts on atom1
     */
    public Space.Vector force(AtomPair pair);
    /**
     * Returns the total long-range correction to the pressure
     *
     * @param n1 the number of atoms of species(Index)1, i.e., x1*N, where x1 is the mole fraction of species 1
     * @param n2 the number of atoms of species 2
     * @param V  the volume of the phase (needed to compute the density)
     */
    public double pressureLRC(int n1, int n2, double V);

//    public double virial(AtomPair pair);
    
    
}
