package simulate;

/**
 * Ideal-gas potential, which defines all atoms to have no interaction
 * Returns a zero energy and force, and an infinite collision time
 */
public class PotentialIdealGas implements PotentialHard, PotentialSoft {
    
    private static Space.Vector zero;
    
    public PotentialIdealGas() {
        zero = Simulation.space.makeVector();
        zero.E(0.0);
    }
    
   /**
    * Always returns zero
    */
    public double energy(AtomPair pair) {return 0.0;}
   /**
    * Always returns zero
    */
    public double energyLRC(int n1, int n2, double V) {return 0.0;}
   /**
    * Always returns zero
    */
    public double pressureLRC(int n1, int n2, double V) {return 0.0;}
    
   /**
    * Always returns false
    */
    public boolean overlap(AtomPair pair) {return false;}

   /**
    * Returns without performing any action to pair
    */
    public void bump(AtomPair pair) {return;}
   /**
    * Always returns infinity (Double.MAX_VALUE)
    */
    public double collisionTime(AtomPair pair) {return Double.MAX_VALUE;}
   /**
    * Always returns zero
    */
    public double lastCollisionVirial() {return 0.0;}
    
   /**
    * Always returns a zero vector
    */
    public Space.Vector force(AtomPair pair) {return zero;}
    
   /**
    * Always returns zero
    */
    public double virial(AtomPair pair) {return 0.0;}
    
}

