package simulate;

/**
 * Methods needed to describe the behavior of a hard potential.  
 * A hard potential describes impulsive interactions, in which the energy undergoes a step
 * change at some separation (and perhaps orientation).  Atoms at this point are said to
 * collide.  Important examples of this type of potential are hard-sphere and square-well.
 *
 * @see PotentialSoft
 */
 
public interface PotentialHard extends Potential {
    
 /**
  * Implements the collision dynamics.
  * The given pair of atoms are assumed to be at the point of collision.  This method is called
  * to change their momenta according to the action of the collision.  Extensions can be defined to
  * instead implement other, perhaps unphysical changes.
  */
    public void bump(AtomPair pair);
 /**
  * Computes the time of collision of the given pair, assuming no intervening collisions.
  * Usually assumes free-flight between collisions
  */ 
    public double collisionTime(AtomPair pair);
 /**
  * Returns the collision virial from the last collision processed by this potential
  * This quantity can be used to measure the pressure
  */
    public double lastCollisionVirial();
    
}