package simulate; 

/**
 * Basic methods needed to describe interaction between atoms.  
 * Molecular interactions are defined in the Potential1 and Potential2 classes by collecting
 * together Potential classes for all atoms pairs that can be made by taking one atom from each
 * molecule.
 *
 * @see Potential1
 * @see Potential2
 */
public interface Potential {
  
  /**
   * Returns the energy of interaction of the pair of atoms passed to the method
   */
  public double energy(AtomPair pair);
  
  /**
   * Returns true if the pair of atoms are considered by this potential to be overlapping in their current positions
   */
  public boolean overlap(AtomPair pair);

    /**
     * Returns the total (extensive) long-range correction to the energy, assuming g(r) = 1 beyond the truncation distance
     * Input are the number of atoms of each type (i.e., x1*N and x2*N, where x1 and x2
     * are the mole fractions of each species interacting according to this potential), and the volume
     * of the phase
     */
    public double energyLRC(int n1, int n2, double V);
}


