package simulate;
import java.beans.Beans;
import java.awt.*;
import simulate.units.*;

/**
 * "Primitive model" potential.  Hard sphere plus Coulomb interaction
 */
public class P2Primitive extends Potential2 {

  private double sigma;
  private Unit.Length sigmaUnit;
  private double cutoff = 2.5;
  PotentialPrimitive onlyPotential = new PotentialPrimitive(sigma,cutoff);

  public P2Primitive() {
    super();
    setSigma(Default.ATOM_SIZE, Default.ATOM_SIZE_UNIT);
  }
  
  public final Potential getPotential(Atom a1, Atom a2) {return onlyPotential;}
  
  public final double getCutoff() {return cutoff;}
  public final void setCutoff(double c) {
    cutoff = c;
    onlyPotential.setCutoff(c);}
  
  public final void setSigma(double d, Unit.Length u) {
    sigmaUnit = u;
    setSigma(d);
  }
  public final void setSigma(double d) {
    sigma = sigmaUnit.toSim(d);
    onlyPotential.setSigma(sigma);
  }
  public final double getSigma() {return sigmaUnit.fromSim(sigma);}
  public final double sigma() {return sigma;}
  public final void setSigmaUnit(Unit.Length u) {sigmaUnit = u;}
  public Unit.Length getSigmaUnit() {return sigmaUnit;}
    
  // Paint a red disk at design time to show size of sigma
  
  public void paint(Graphics g) {
    int moleculePixelPositionX, moleculePixelPositionY, moleculePixelDiameter, wellPixelDiameter;
    int[] simulationPixelDimensions = {-1, -1}; // pixel width (0) and height (1) of simulation box less boundaries. 
    if(Beans.isDesignTime()) {
        if(getParent() != null) {
            Component par = getParent();
            simulationPixelDimensions[0] = par.getSize().width;
            simulationPixelDimensions[1] = par.getSize().height;
            double scale = Math.max(simulationPixelDimensions[0], simulationPixelDimensions[1]);
            moleculePixelDiameter = (int)(scale*sigma);
            g.setColor(Color.red);
            g.fillOval(0,0,moleculePixelDiameter,moleculePixelDiameter);
        }
    }
  }  
}


