package simulate;
import java.beans.Beans;
import java.awt.*;
import simulate.units.*;

public class P2LennardJones extends Potential2 {

  private double sigma;
  private double epsilon;
  private Unit.Length sigmaUnit;
  private Unit.Energy epsilonUnit;
  private double cutoff = 2.5;
  private final PotentialLJ onlyPotential;

  public P2LennardJones() {
    super();
    setSigma(Default.ATOM_SIZE, Default.ATOM_SIZE_UNIT);
    setEpsilon(Default.POTENTIAL_WELL, Default.POTENTIAL_WELL_UNIT);
    onlyPotential = new PotentialLJ(sigma,epsilon,cutoff);
  }
  
  public final Potential getPotential(Atom a1, Atom a2) {return onlyPotential;}
  
  public final double getCutoff() {return cutoff;}
  public final void setCutoff(double c) {
    cutoff = c;
    onlyPotential.setCutoff(c);}
  
  public final void setSigma(double d, Unit.Length u) {
    sigmaUnit = u;
    setSigma(d);
  }
  public final void setSigma(double d) {
    sigma = sigmaUnit.toSim(d);
    onlyPotential.setSigma(sigma);
  }
  public final double getSigma() {return sigmaUnit.fromSim(sigma);}
  public final double sigma() {return sigma;}
  public final void setSigmaUnit(Unit.Length u) {sigmaUnit = u;}
  public Unit.Length getSigmaUnit() {return sigmaUnit;}
    
  // Epsilon and its units
  public final void setEpsilon(double eps, Unit.Energy u) {
    epsilonUnit = u;
    setEpsilon(eps);
  }
  public final void setEpsilon(double eps) {
    epsilon = epsilonUnit.toSim(eps);
    onlyPotential.setEpsilon(epsilon);
  }
  public final double getEpsilon() {return epsilonUnit.fromSim(epsilon);}
  public final double epsilon() {return epsilon;}
  public final void setEpsilonUnit(Unit.Energy u) {epsilonUnit = u;}
  public Unit.Energy getEpsilonUnit() {return epsilonUnit;}
  
  // Paint a red disk at design time to show size of sigma
  
  public void paint(Graphics g) {
    int moleculePixelPositionX, moleculePixelPositionY, moleculePixelDiameter, wellPixelDiameter;
    int[] simulationPixelDimensions = {-1, -1}; // pixel width (0) and height (1) of simulation box less boundaries. 
    if(Beans.isDesignTime()) {
        if(getParent() != null) {
            Component par = getParent();
            simulationPixelDimensions[0] = par.getSize().width;
            simulationPixelDimensions[1] = par.getSize().height;
            double scale = Math.max(simulationPixelDimensions[0], simulationPixelDimensions[1]);
            moleculePixelDiameter = (int)(scale*sigma);
            g.setColor(Color.red);
            g.fillOval(0,0,moleculePixelDiameter,moleculePixelDiameter);
        }
    }
  }  
}


