package simulate;
import java.beans.Beans;
import java.awt.*;

public class P2DiskPiston extends Potential2 {

  private double collisionDiameter;
  private PotentialHardDiskPiston onlyPotential;

  public P2DiskPiston() {
    super();
    collisionDiameter = Default.ATOM_SIZE;
    onlyPotential = new PotentialHardDiskPiston(collisionDiameter);
    setCollisionDiameter(collisionDiameter);  //sets up neighbor distances 
  }
  
  public final boolean isNeighbor(Molecule m1, Molecule m2) {
    return true;
  }
  
  public final Potential getPotential(Atom a1, Atom a2) {return onlyPotential;}
  
  public final double getCollisionDiameter() {return collisionDiameter;}
  public final void setCollisionDiameter(double d) {
    collisionDiameter = d;
    onlyPotential.setCollisionDiameter(d);
    setPotentialCutoff(d);
  }
}


