package simulate;

/**
 * Meter for measurement of the temperature based on kinetic-energy equipartition
 */

public final class MeterTemperature extends Meter
{
    public MeterTemperature()
    {
        super();
        setLabel("Temperature");
    }

    public double currentValue()
    {
        return value(phase);
    }

/**
 * Class method to compute the temperature of a phase from its total kinetic energy using equipartition
 */
    public static double value(Phase phase) {
        return (2./(double)(phase.atomCount*Simulation.D))*phase.energy.kinetic();
    }    
}