package simulate;

/**
 * Takes measurments to average pressure from momentum flux at Boundary of Space
 * Intended for use with BoundaryHard
 */
 
public class MeterPressureBoundary extends Meter
{
    private double momentumSum = 0.0;
    private double timeSum = 0.0;

    public MeterPressureBoundary()
    {
        super();
        setLabel("Pressure");
    }
    
    public void intervalAction(Integrator.IntervalEvent evt) {
        IntegratorMD integrator = (IntegratorMD)evt.getSource();
        timeSum += integrator.timeStep * integrator.interval;
        updateSums();}

    public double currentValue()
    {
        Space2D.BoundaryHard bnd = (Space2D.BoundaryHard)phase.boundary;
        double flux = bnd.pAccumulator/timeSum;   //divide by time interval
        flux /= (2*(bnd.dimensions.x+bnd.dimensions.y)); //divide by area
        timeSum = 0.0;          //zeroing should be moved to intervalAction?
        bnd.pAccumulator = 0.0;
        return flux;
    }
}