/*
 * Decompiled with CFR 0.152.
 */
package simulate;

import simulate.Atom;
import simulate.AtomPair;
import simulate.Iterator;
import simulate.Lattice;
import simulate.LatticeSquare;
import simulate.Molecule;
import simulate.Phase;
import simulate.Potential;
import simulate.PotentialHard;
import simulate.Space;
import simulate.Space2D;

public class Space2DCell
extends Space2D
implements Iterator.Maker {
    static /* synthetic */ Class class$simulate$LatticeSquare$Cell;

    public Space.Coordinate makeCoordinate(Space.Occupant o) {
        return new Coordinate(o);
    }

    public Iterator makeIterator(Phase p) {
        return new NeighborIterator(p);
    }

    public Potential makePotential() {
        return new CellPotential();
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public class Coordinate
    extends Space2D.Coordinate
    implements Lattice.Occupant {
        Coordinate nextNeighbor;
        Coordinate previousNeighbor;
        public LatticeSquare.Site cell;

        public Coordinate(Space.Occupant o) {
            super(o);
            Space2DCell.this = Space2DCell.this;
        }

        public void assignCell() {
            LatticeSquare cells = ((NeighborIterator)this.parentPhase().iterator()).cells;
            LatticeSquare.Site newCell = cells.nearestSite(this.r, (Space2D.Vector)this.parentPhase().dimensions());
            if (newCell != this.cell) {
                this.assignCell(newCell);
            }
        }

        public void assignCell(LatticeSquare.Site newCell) {
            if (this.previousNeighbor != null) {
                this.previousNeighbor.setNextNeighbor(this.nextNeighbor);
            } else {
                if (this.cell != null) {
                    this.cell.setFirst(this.nextNeighbor);
                }
                if (this.nextNeighbor != null) {
                    this.nextNeighbor.clearPreviousNeighbor();
                }
            }
            this.cell = newCell;
            if (newCell == null) {
                return;
            }
            this.setNextNeighbor((Coordinate)this.cell.first());
            this.cell.setFirst(this);
            this.clearPreviousNeighbor();
        }

        public final void clearPreviousNeighbor() {
            this.previousNeighbor = null;
        }

        public final Coordinate nextNeighbor() {
            return this.nextNeighbor;
        }

        public final Coordinate previousNeighbor() {
            return this.previousNeighbor;
        }

        public final void setNextNeighbor(Coordinate c) {
            this.nextNeighbor = c;
            if (c != null) {
                c.previousNeighbor = this;
            }
        }

        public final Lattice.Site site() {
            return this.cell;
        }
    }

    public static final class NeighborIterator
    extends Iterator {
        public LatticeSquare cells = new LatticeSquare(class$simulate$LatticeSquare$Cell != null ? class$simulate$LatticeSquare$Cell : (class$simulate$LatticeSquare$Cell = Space2DCell.class$("simulate.LatticeSquare$Cell")), new int[]{this.xCells, this.yCells});
        private int xCells = 15;
        private int yCells = 15;
        private double neighborRadius;

        public NeighborIterator(Phase p) {
            super(p);
        }

        public void addMolecule(Molecule m) {
            m.atomIterator.reset();
            while (m.atomIterator.hasNext()) {
                ((Coordinate)m.atomIterator.next().coordinate).assignCell();
            }
        }

        public void deleteMolecule(Molecule m) {
            m.atomIterator.reset();
            while (m.atomIterator.hasNext()) {
                ((Coordinate)m.atomIterator.next().coordinate).assignCell(null);
            }
        }

        public double getNeighborRadius() {
            return this.neighborRadius;
        }

        public final Atom.Iterator makeAtomIteratorDown() {
            return new AtomIteratorDown(this.cells);
        }

        public final Atom.Iterator makeAtomIteratorUp() {
            return new AtomIteratorUp(this.cells);
        }

        public final AtomPair.Iterator.A makeAtomPairIteratorDown() {
            return new AtomPairIteratorDown(this.phase, this.cells);
        }

        public final AtomPair.Iterator.A makeAtomPairIteratorUp() {
            return new AtomPairIteratorUp(this.phase, this.cells);
        }

        public void moveNotify(Atom a) {
            ((Coordinate)a.coordinate).assignCell();
        }

        public void reset() {
            this.cells.clearOccupants();
            Atom a = this.phase.firstAtom();
            while (a != null) {
                Coordinate c = (Coordinate)a.coordinate();
                c.cell = null;
                c.clearPreviousNeighbor();
                c.setNextNeighbor(null);
                ((Coordinate)a.coordinate()).assignCell();
                a = a.nextAtom();
            }
        }

        public void setNeighborRadius(double radius) {
            this.neighborRadius = radius;
            this.cells.setNeighborIndexCutoff(radius * radius);
            this.reset();
        }

        private static final class AtomPairIteratorUp
        implements AtomPair.Iterator.A {
            private final Phase phase;
            private final LatticeSquare cells;
            final AtomPair pair;
            final Space2D.CoordinatePair cPair;
            Atom atom;
            private boolean hasNext;
            private Coordinate neighborCoordinate;
            private LatticeSquare.Site neighborCell;
            private LatticeSquare.Linker nextLinker;

            public AtomPairIteratorUp(Phase p, LatticeSquare c) {
                this.phase = p;
                this.cells = c;
                this.pair = new AtomPair(p);
                this.cPair = (Space2D.CoordinatePair)this.phase.space().makeCoordinatePair(p.boundary());
                this.hasNext = false;
            }

            private void advanceCell() {
                while (this.neighborCoordinate == null) {
                    if (this.nextLinker == null) {
                        this.hasNext = false;
                        return;
                    }
                    this.neighborCell = this.nextLinker.site();
                    this.neighborCoordinate = (Coordinate)this.neighborCell.first();
                    this.nextLinker = this.nextLinker.next();
                }
            }

            public void allDone() {
                this.hasNext = false;
            }

            public boolean hasNext() {
                return this.hasNext;
            }

            public AtomPair next() {
                this.cPair.c2 = this.neighborCoordinate;
                this.cPair.reset();
                this.pair.reset(this.atom, (Atom)this.neighborCoordinate.parent(), this.cPair);
                this.neighborCoordinate = this.neighborCoordinate.nextNeighbor;
                if (this.neighborCoordinate == null) {
                    this.advanceCell();
                }
                return this.pair;
            }

            public void reset() {
                this.reset(this.atom, true);
            }

            public void reset(Atom a, boolean intra) {
                this.atom = a;
                if (a.parentPhase() == this.phase) {
                    Coordinate c = (Coordinate)a.coordinate;
                    this.cPair.c1 = c;
                    this.nextLinker = c.cell.firstUpNeighbor();
                    this.neighborCoordinate = c.nextNeighbor();
                } else {
                    Coordinate c = (Coordinate)a.coordinate;
                    this.cPair.c1 = c;
                    LatticeSquare.Site cell = this.cells.nearestSite(c.r, (Space2D.Vector)this.phase.dimensions());
                    this.nextLinker = cell.firstUpNeighbor();
                    this.neighborCoordinate = (Coordinate)cell.first();
                }
                this.hasNext = true;
                if (this.neighborCoordinate == null) {
                    this.advanceCell();
                }
            }
        }

        private static final class AtomPairIteratorDown
        implements AtomPair.Iterator.A {
            final AtomPair pair;
            private final Phase phase;
            private final LatticeSquare cells;
            final Space2D.CoordinatePair cPair;
            Atom atom;
            private boolean hasNext;
            private Coordinate coordinate;
            private Coordinate neighborCoordinate;
            private LatticeSquare.Site neighborCell;
            private LatticeSquare.Linker nextLinker;
            private boolean firstCell;

            public AtomPairIteratorDown(Phase p, LatticeSquare c) {
                this.phase = p;
                this.cells = c;
                this.pair = new AtomPair(p);
                this.cPair = (Space2D.CoordinatePair)this.phase.space().makeCoordinatePair(p.boundary());
                this.hasNext = false;
            }

            private void advanceCell() {
                this.firstCell = false;
                while (this.neighborCoordinate == null) {
                    if (this.nextLinker == null) {
                        this.hasNext = false;
                        return;
                    }
                    this.neighborCell = this.nextLinker.site();
                    this.neighborCoordinate = (Coordinate)this.neighborCell.first;
                    this.nextLinker = this.nextLinker.next();
                }
            }

            public void allDone() {
                this.hasNext = false;
            }

            public boolean hasNext() {
                return this.hasNext;
            }

            public AtomPair next() {
                this.cPair.c2 = this.neighborCoordinate;
                this.cPair.reset();
                this.pair.reset(this.atom, (Atom)this.neighborCoordinate.parent(), this.cPair);
                Coordinate coordinate = this.neighborCoordinate = this.firstCell ? this.neighborCoordinate.previousNeighbor : this.neighborCoordinate.nextNeighbor;
                if (this.neighborCoordinate == null) {
                    this.advanceCell();
                }
                return this.pair;
            }

            public void reset() {
                this.reset(this.atom, true);
            }

            public void reset(Atom a, boolean intra) {
                this.atom = a;
                if (a.parentPhase() == this.phase) {
                    Coordinate c = (Coordinate)a.coordinate;
                    this.cPair.c1 = c;
                    this.nextLinker = c.cell.firstDownNeighbor();
                    this.neighborCoordinate = c.previousNeighbor();
                } else {
                    Coordinate c = (Coordinate)a.coordinate;
                    this.cPair.c1 = c;
                    LatticeSquare.Site cell = this.cells.nearestSite(c.r, (Space2D.Vector)this.phase.dimensions());
                    this.nextLinker = cell.firstDownNeighbor();
                    this.neighborCoordinate = null;
                }
                this.firstCell = true;
                this.hasNext = true;
                if (this.neighborCoordinate == null) {
                    this.advanceCell();
                }
            }
        }

        private static final class AtomIteratorUp
        implements Atom.Iterator {
            private Coordinate coordinate;
            private Atom nextAtom;
            private Atom firstAtom;
            private final LatticeSquare cells;
            private boolean hasNext = false;
            private LatticeSquare.Site cell;

            public AtomIteratorUp(LatticeSquare c) {
                this.cells = c;
            }

            private void advanceCell() {
                while (this.coordinate == null) {
                    this.cell = this.cell.nextSite();
                    if (this.cell == null) {
                        this.allDone();
                        return;
                    }
                    this.coordinate = (Coordinate)this.cell.first;
                }
            }

            public void allDone() {
                this.hasNext = false;
            }

            public boolean hasNext() {
                return this.hasNext;
            }

            public Atom next() {
                this.nextAtom = (Atom)this.coordinate.parent();
                this.coordinate = this.coordinate.nextNeighbor;
                if (this.coordinate == null) {
                    this.advanceCell();
                }
                return this.nextAtom;
            }

            public void reset() {
                this.hasNext = true;
                this.cell = this.cells.origin;
                this.coordinate = (Coordinate)this.cell.first();
                if (this.coordinate == null) {
                    this.advanceCell();
                }
            }

            public void reset(Atom a) {
                this.firstAtom = a;
                if (a == null) {
                    this.allDone();
                    return;
                }
                this.coordinate = (Coordinate)a.coordinate();
                this.cell = this.coordinate.cell;
                this.hasNext = true;
            }
        }

        private static final class AtomIteratorDown
        implements Atom.Iterator {
            private Coordinate coordinate;
            private Atom nextAtom;
            private Atom firstAtom;
            private final LatticeSquare cells;
            private boolean hasNext = false;
            private LatticeSquare.Site cell;
            private LatticeSquare.Site neighborCell;
            private LatticeSquare.Linker nextLinker;
            private boolean firstCell;

            public AtomIteratorDown(LatticeSquare c) {
                this.cells = c;
            }

            private void advanceCell() {
                this.firstCell = false;
                while (this.coordinate == null) {
                    this.cell = this.cell.previousSite();
                    if (this.cell == null) {
                        this.allDone();
                        return;
                    }
                    this.coordinate = (Coordinate)this.cell.first();
                }
            }

            public void allDone() {
                this.hasNext = false;
            }

            public boolean hasNext() {
                return this.hasNext;
            }

            public Atom next() {
                this.nextAtom = (Atom)this.coordinate.parent();
                Coordinate coordinate = this.coordinate = this.firstCell ? this.coordinate.previousNeighbor : this.coordinate.nextNeighbor;
                if (this.coordinate == null) {
                    this.advanceCell();
                }
                return this.nextAtom;
            }

            public void reset() {
                System.out.println("Error:  should not be calling reset() in Space2DCell.NeighborIterator.AtomIteratorDown");
                this.reset(this.firstAtom);
            }

            public void reset(Atom a) {
                this.firstAtom = a;
                if (a == null) {
                    this.allDone();
                    return;
                }
                this.coordinate = (Coordinate)a.coordinate();
                this.cell = this.coordinate.cell;
                this.hasNext = true;
                this.firstCell = true;
            }
        }
    }

    public static class CellPotential
    extends Potential
    implements PotentialHard {
        public void bump(AtomPair pair) {
            Atom atom = pair.atom1();
            Coordinate atomCoordinate = (Coordinate)atom.coordinate();
            LatticeSquare.Point cell = (LatticeSquare.Point)atomCoordinate.cell;
            double dx = atomCoordinate.r.x - cell.position()[0];
            double dy = atomCoordinate.r.y - cell.position()[1];
            if (Math.abs(dx) > Math.abs(dy)) {
                if (dx > 0.0) {
                    atomCoordinate.r.x = ((LatticeSquare.Cell)cell.E()).vertices()[2][0];
                    atomCoordinate.assignCell(cell.E());
                } else {
                    atomCoordinate.r.x = ((LatticeSquare.Cell)cell.W()).vertices()[0][0];
                    atomCoordinate.assignCell(cell.W());
                }
            } else if (dy > 0.0) {
                atomCoordinate.r.y = ((LatticeSquare.Cell)cell.S()).vertices()[2][1];
                atomCoordinate.assignCell(cell.S());
            } else {
                atomCoordinate.r.y = ((LatticeSquare.Cell)cell.N()).vertices()[0][1];
                atomCoordinate.assignCell(cell.N());
            }
        }

        public double collisionTime(AtomPair pair) {
            Coordinate atomCoordinate = (Coordinate)pair.atom1().coordinate;
            LatticeSquare.Cell cell = (LatticeSquare.Cell)atomCoordinate.cell;
            double dx = atomCoordinate.p.x > 0.0 ? cell.vertices()[0][0] - atomCoordinate.r.x : cell.vertices()[2][0] - atomCoordinate.r.x;
            double tx = Math.abs(dx / atomCoordinate.p.x);
            double dy = atomCoordinate.p.y > 0.0 ? cell.vertices()[0][1] - atomCoordinate.r.y : cell.vertices()[2][1] - atomCoordinate.r.y;
            double ty = Math.abs(dy / atomCoordinate.p.y);
            return tx > ty ? ty * atomCoordinate.parent().mass() : tx * atomCoordinate.parent().mass();
        }
    }
}

