/*
 * Decompiled with CFR 0.152.
 */
package simulate;

import java.awt.Graphics;
import simulate.Phase;
import simulate.Potential;
import simulate.PotentialIdealGas;

public abstract class Space {
    public abstract int D();

    public void draw(Graphics g, int[] origin, double scale) {
    }

    public abstract Boundary makeBoundary(int var1);

    public abstract Coordinate makeCoordinate(Occupant var1);

    public abstract CoordinatePair makeCoordinatePair(Boundary var1);

    public abstract CoordinatePair makeCoordinatePair(Coordinate var1, Coordinate var2, Boundary var3);

    public Potential makePotential() {
        return new PotentialIdealGas();
    }

    public abstract Vector makeVector();

    interface Occupant {
        public Coordinate coordinate();

        public double mass();

        public Phase parentPhase();

        public double rm();
    }

    public static abstract class Vector {
        public abstract void DE(double var1);

        public abstract void DE(Vector var1);

        public abstract void E(double var1);

        public abstract void E(Vector var1);

        public abstract void Ea1Tv1(double var1, Vector var3);

        public abstract void ME(Vector var1);

        public abstract void PE(Vector var1);

        public abstract void PEa1Tv1(double var1, Vector var3);

        public abstract void TE(double var1);

        public abstract void TE(Vector var1);

        public abstract double component(int var1);

        public abstract double dot(Vector var1);

        public abstract void setComponent(int var1, double var2);

        public abstract void setRandom(double var1);

        public abstract void setRandomCube();

        public abstract void setRandomSphere();

        public abstract double squared();
    }

    public static abstract class Coordinate {
        protected final Occupant parent;

        Coordinate(Occupant p) {
            this.parent = p;
        }

        public abstract double kineticEnergy(double var1);

        public abstract Vector makeVector();

        public abstract Vector momentum();

        public abstract double momentum(int var1);

        public final Occupant parent() {
            return this.parent;
        }

        public final Phase parentPhase() {
            return this.parent.parentPhase();
        }

        public abstract Vector position();

        public abstract double position(int var1);

        public void scaleMomentum(double scale) {
            this.momentum().TE(scale);
        }
    }

    public static abstract class CoordinatePair {
        public Coordinate coordinate1;
        public Coordinate coordinate2;
        public double r2;
        public Potential potential;

        public final Coordinate coordinate1() {
            return this.coordinate1;
        }

        public final Coordinate coordinate2() {
            return this.coordinate2;
        }

        public abstract void push(double var1);

        public final double r2() {
            return this.r2;
        }

        public abstract void reset();

        public abstract void reset(Coordinate var1, Coordinate var2);

        public abstract void setSeparation(double var1);

        public abstract double v2();

        public abstract double vDotr();
    }

    interface Boundary {
        public static final int NONE = 0;
        public static final int PERIODIC = 1;
        public static final int DEFAULT = 1;

        public void centralImage(Vector var1);

        public Vector dimensions();

        public void draw(Graphics var1, int[] var2, double var3);

        public double[][] getOverflowShifts(Vector var1, double var2);

        public double[][] imageOrigins(int var1);

        public void inflate(double var1);

        public Vector randomPosition();

        public double volume();
    }
}

