/*
 * Decompiled with CFR 0.152.
 */
package simulate;

import java.awt.Color;
import java.awt.Container;
import java.awt.Graphics;
import java.beans.Beans;
import simulate.Atom;
import simulate.Potential;
import simulate.Potential2;
import simulate.PotentialSquareWell;

public class P2SquareWell
extends Potential2 {
    private double coreDiameter = 0.1;
    private double lambda = 1.5;
    private double epsilon = 300.0;

    public P2SquareWell() {
        this.nAtoms1 = 1;
        this.nAtoms2 = 1;
        this.potential = new Potential[this.nAtoms1][this.nAtoms2];
        this.potential[0][0] = new PotentialSquareWell(0.1, 1.5, 300.0);
        this.setLambda(this.lambda);
    }

    public final double getCoreDiameter() {
        return this.coreDiameter;
    }

    public final double getEpsilon() {
        return this.epsilon;
    }

    public final double getLambda() {
        return this.lambda;
    }

    public final Potential getPotential(Atom a1, Atom a2) {
        return this.potential[0][0];
    }

    public void paint(Graphics g) {
        int[] simulationPixelDimensions = new int[]{-1, -1};
        if (Beans.isDesignTime() && this.getParent() != null) {
            Container par = this.getParent();
            simulationPixelDimensions[0] = par.getSize().width;
            simulationPixelDimensions[1] = par.getSize().height;
            double scale = Math.max(simulationPixelDimensions[0], simulationPixelDimensions[1]);
            int moleculePixelDiameter = (int)(scale * this.coreDiameter);
            int wellPixelDiameter = (int)(scale * this.lambda * this.coreDiameter);
            g.setColor(Color.red);
            g.fillOval((wellPixelDiameter - moleculePixelDiameter) / 2, (wellPixelDiameter - moleculePixelDiameter) / 2, moleculePixelDiameter, moleculePixelDiameter);
            g.setColor(Color.blue);
            g.drawOval(0, 0, wellPixelDiameter, wellPixelDiameter);
        }
    }

    public final void setCoreDiameter(double d) {
        this.coreDiameter = d;
        this.setPotentialCutoff(this.coreDiameter * this.lambda);
        ((PotentialSquareWell)this.potential[0][0]).setCoreDiameter(d);
    }

    public final void setEpsilon(double eps) {
        this.epsilon = eps;
        ((PotentialSquareWell)this.potential[0][0]).setEpsilon(eps);
    }

    public final void setEpsilon(int eps) {
        this.setEpsilon((double)eps);
    }

    public final void setLambda(double lam) {
        this.lambda = lam;
        this.setPotentialCutoff(this.coreDiameter * this.lambda);
        ((PotentialSquareWell)this.potential[0][0]).setLambda(lam);
    }
}

