/*
 * Decompiled with CFR 0.152.
 */
package simulate;

import java.awt.Graphics;
import java.io.Serializable;
import simulate.Atom;
import simulate.AtomType;
import simulate.Phase;
import simulate.Potential1;
import simulate.Potential2;
import simulate.Space;
import simulate.Species;

public class Molecule
implements Space.Occupant,
Serializable {
    Phase parentPhase;
    Species parentSpecies;
    Molecule nextMolecule;
    Molecule previousMolecule;
    Atom firstAtom;
    Atom lastAtom;
    int nAtoms;
    public Space.Coordinate coordinate;
    public Space.Vector r;
    public Space.Vector p;
    public Atom.Iterator atomIterator;
    protected Space.Vector temp;

    public Molecule(Species ps, Phase pp, AtomType type, int n) {
        this.parentSpecies = ps;
        this.parentPhase = pp;
        this.coordinate = this.parentSpecies.parentSimulation.space.makeCoordinate(this);
        this.r = this.coordinate.position();
        this.p = this.coordinate.momentum();
        this.temp = this.parentSpecies.parentSimulation.space.makeVector();
        this.nAtoms = n;
        this.atomIterator = this.nAtoms > 1 ? new AtomIterator() : new MonoAtomIterator();
        this.lastAtom = this.firstAtom = new Atom(this, type, 0);
        int i = 1;
        while (i < this.nAtoms) {
            this.lastAtom.setNextAtom(new Atom(this, type, i));
            this.lastAtom = this.lastAtom.nextAtom();
            ++i;
        }
    }

    public Molecule(Species ps, Phase pp, AtomType[] type) {
        this.parentSpecies = ps;
        this.parentPhase = pp;
        this.coordinate = this.parentSpecies.parentSimulation.space.makeCoordinate(this);
        this.r = this.coordinate.position();
        this.p = this.coordinate.momentum();
        this.nAtoms = type.length;
        this.atomIterator = this.nAtoms > 1 ? new AtomIterator() : new MonoAtomIterator();
        this.temp = this.parentSpecies.parentSimulation.space.makeVector();
        this.lastAtom = this.firstAtom = new Atom(this, type[0], 0);
        int i = 1;
        while (i < this.nAtoms) {
            this.lastAtom.setNextAtom(new Atom(this, type[i], i));
            this.lastAtom = this.lastAtom.nextAtom();
            ++i;
        }
    }

    public final Space.Vector COM() {
        this.updateR();
        return this.r;
    }

    public final void clearPreviousMolecule() {
        this.previousMolecule = null;
        this.firstAtom.clearPreviousAtom();
    }

    public final Space.Coordinate coordinate() {
        return this.coordinate;
    }

    public void displaceBy(Space.Vector u) {
        this.atomIterator.reset();
        while (this.atomIterator.hasNext()) {
            this.atomIterator.next().displaceBy(u);
        }
    }

    public void displaceTo(Space.Vector u) {
        this.updateR();
        this.temp.E(u);
        this.temp.ME(this.r);
        this.displaceBy(this.temp);
    }

    public void displaceToRandom(Phase phase) {
        this.displaceTo(phase.boundary().randomPosition());
    }

    public void displaceWithin(double d) {
        this.temp.setRandom(d);
        this.displaceBy(this.temp);
    }

    public void draw(Graphics g, int[] origin, double scale) {
        Atom terminator = this.terminationAtom();
        Atom a = this.firstAtom;
        while (a != terminator) {
            a.draw(g, origin, scale);
            a = a.nextAtom();
        }
    }

    public final Atom firstAtom() {
        return this.firstAtom;
    }

    public final int getNAtoms() {
        return this.nAtoms;
    }

    public final Potential1 getP1() {
        return this.parentSpecies.parentSimulation.potential1[this.getSpeciesIndex()];
    }

    public final Potential2[] getP2() {
        return this.parentSpecies.parentSimulation.potential2[this.getSpeciesIndex()];
    }

    public final Species getSpecies() {
        return this.parentSpecies;
    }

    public final int getSpeciesIndex() {
        return this.parentSpecies.getSpeciesIndex();
    }

    public void inflate(double s) {
        this.updateR();
        this.temp.Ea1Tv1(s - 1.0, this.r);
        this.displaceBy(this.temp);
    }

    public double kineticEnergy() {
        this.updateP();
        return 0.5 * this.p.squared() * this.rm();
    }

    public final Atom lastAtom() {
        return this.lastAtom;
    }

    public final double mass() {
        if (this.nAtoms == 1) {
            return this.firstAtom.type.mass();
        }
        double mass = 0.0;
        Atom a = this.firstAtom();
        while (a != this.terminationAtom()) {
            mass += a.type.mass();
            a = a.nextAtom();
        }
        return mass;
    }

    public Space.Vector momentum() {
        this.updateP();
        return this.p;
    }

    public double momentum(int i) {
        this.updateP();
        return this.p.component(i);
    }

    public final Molecule nextMolecule() {
        return this.nextMolecule;
    }

    public final Phase parentPhase() {
        return this.parentPhase;
    }

    public Space.Vector position() {
        this.updateR();
        return this.r;
    }

    public double position(int i) {
        this.updateR();
        return this.r.component(i);
    }

    public final Molecule previousMolecule() {
        return this.previousMolecule;
    }

    public void randomizeMomentum(double temperature) {
        this.atomIterator.reset();
        while (this.atomIterator.hasNext()) {
            this.atomIterator.next().randomizeMomentum(temperature);
        }
    }

    public void replace() {
        this.atomIterator.reset();
        while (this.atomIterator.hasNext()) {
            this.atomIterator.next().replace();
        }
    }

    public final double rm() {
        if (this.nAtoms == 1) {
            return this.firstAtom.type.rm();
        }
        return 1.0 / this.mass();
    }

    public final void setCOM(Space.Vector u) {
        this.translateTo(u);
    }

    public final void setNextMolecule(Molecule m) {
        this.nextMolecule = m;
        if (m == null) {
            this.lastAtom.setNextAtom(null);
        } else {
            m.previousMolecule = this;
            this.lastAtom.setNextAtom(m.firstAtom);
        }
    }

    public final Atom terminationAtom() {
        return this.lastAtom.nextAtom();
    }

    public void translateBy(Space.Vector u) {
        this.atomIterator.reset();
        while (this.atomIterator.hasNext()) {
            this.atomIterator.next().translateBy(u);
        }
    }

    public void translateTo(Space.Vector u) {
        this.updateR();
        this.temp.E(u);
        this.temp.ME(this.r);
        this.translateBy(this.temp);
    }

    public void translateToward(Space.Vector u, double d) {
        this.temp.Ea1Tv1(d, u);
        this.translateBy(this.temp);
    }

    public void updateP() {
        this.p.E(0.0);
        this.atomIterator.reset();
        while (this.atomIterator.hasNext()) {
            this.p.PE(this.atomIterator.next().momentum());
        }
    }

    public void updateR() {
        if (this.nAtoms == 1) {
            this.r.E(this.firstAtom.coordinate().position());
        } else {
            this.r.E(0.0);
            this.atomIterator.reset();
            while (this.atomIterator.hasNext()) {
                Atom a = this.atomIterator.next();
                this.r.PEa1Tv1(a.mass(), a.coordinate().position());
            }
            this.r.DE(this.mass());
        }
    }

    public final class AtomIterator
    implements Atom.Iterator {
        private Atom atom;
        private Atom nextAtom;
        private boolean hasNext;

        public AtomIterator() {
            Molecule.this = Molecule.this;
            this.reset();
        }

        public boolean hasNext() {
            return this.hasNext;
        }

        public Atom next() {
            this.nextAtom = this.atom;
            if (this.atom == Molecule.this.lastAtom) {
                this.hasNext = false;
            } else {
                this.atom = this.atom.nextAtom();
            }
            return this.nextAtom;
        }

        public void reset() {
            this.atom = Molecule.this.firstAtom;
            this.hasNext = true;
        }

        public void reset(Atom a) {
            this.reset();
        }
    }

    public final class MonoAtomIterator
    implements Atom.Iterator {
        private boolean hasNext;

        public MonoAtomIterator() {
            Molecule.this = Molecule.this;
            this.reset();
        }

        public boolean hasNext() {
            return this.hasNext;
        }

        public Atom next() {
            this.hasNext = false;
            return Molecule.this.firstAtom;
        }

        public void reset() {
            this.hasNext = true;
        }

        public void reset(Atom a) {
            this.reset();
        }
    }
}

