/*
 * Decompiled with CFR 0.152.
 */
package simulate;

import simulate.Atom;
import simulate.AtomPair;
import simulate.Meter;
import simulate.Molecule;
import simulate.Phase;

public class MeterPotentialEnergy
extends Meter {
    AtomPair.Iterator iterator;
    AtomPair.Iterator.MP iteratorMP;
    AtomPair.Iterator iteratorAll;
    AtomPair.Iterator.A apiUp;
    AtomPair.Iterator.A apiDown;

    public MeterPotentialEnergy() {
        this.setLabel("Potential Energy");
    }

    public final double currentValue() {
        double pe = 0.0;
        this.iteratorAll.reset();
        while (this.iteratorAll.hasNext()) {
            AtomPair pair = this.iteratorAll.next();
            double energy = this.phase.parentSimulation.getPotential(pair).energy(pair);
            if (energy == Double.MAX_VALUE) {
                return Double.MAX_VALUE;
            }
            pe += energy;
        }
        return pe;
    }

    public final double currentValue(Atom a) {
        double energy;
        AtomPair pair;
        if (this.phase != a.parentPhase()) {
            return 0.0;
        }
        double pe = 0.0;
        this.apiUp.reset(a, false);
        while (this.apiUp.hasNext()) {
            pair = this.apiUp.next();
            energy = this.phase.parentSimulation.getPotential(pair).energy(pair);
            if (energy == Double.MAX_VALUE) {
                return Double.MAX_VALUE;
            }
            pe += energy;
        }
        this.apiDown.reset(a, false);
        while (this.apiDown.hasNext()) {
            pair = this.apiDown.next();
            energy = this.phase.parentSimulation.getPotential(pair).energy(pair);
            if (energy == Double.MAX_VALUE) {
                return Double.MAX_VALUE;
            }
            pe += energy;
        }
        return pe;
    }

    public final double currentValue(Molecule m) {
        this.iteratorMP.reset(m);
        double pe = 0.0;
        while (this.iteratorMP.hasNext()) {
            AtomPair pair = this.iteratorMP.next();
            pe += this.phase.parentSimulation.getPotential(pair).energy(pair);
        }
        return pe;
    }

    public final double insertionValue(Molecule m) {
        this.iteratorMP.reset(m);
        double pe = 0.0;
        while (this.iteratorMP.hasNext()) {
            AtomPair pair = this.iteratorMP.next();
            double energy = this.phase.parentSimulation.getPotential(pair).energy(pair);
            if (energy == Double.MAX_VALUE) {
                return Double.MAX_VALUE;
            }
            pe += energy;
        }
        return pe;
    }

    public void setPhase(Phase p) {
        super.setPhase(p);
        this.iteratorMP = new AtomPair.Iterator.MP(p);
        this.iteratorAll = p.iterator.makeAtomPairIteratorAll();
        this.apiUp = p.iterator.makeAtomPairIteratorUp();
        this.apiDown = p.iterator.makeAtomPairIteratorDown();
    }
}

