/*
 * Decompiled with CFR 0.152.
 */
package simulate;

import java.awt.Color;
import simulate.Atom;
import simulate.Constants;
import simulate.Lattice;
import simulate.Space2D;

public class LatticeSquare
extends Lattice {
    public Site origin;
    public double[][] basis;
    private int[] dimensions;
    private Site[][] sites;

    public LatticeSquare(Class siteType, int[] dim) {
        double[][] dArrayArray = new double[2][];
        double[] dArray = new double[2];
        dArray[0] = 1.0;
        dArrayArray[0] = dArray;
        double[] dArray2 = new double[2];
        dArray2[1] = 1.0;
        dArrayArray[1] = dArray2;
        this.basis = dArrayArray;
        this.dimensions = dim;
        this.basis[0][0] = 1.0 / (double)this.dimensions[0];
        this.basis[1][1] = 1.0 / (double)this.dimensions[1];
        Site last = null;
        this.sites = new Site[this.dimensions[0]][this.dimensions[1]];
        int j = 0;
        while (j < this.dimensions[1]) {
            int i = 0;
            while (i < this.dimensions[0]) {
                try {
                    this.sites[i][j] = (Site)siteType.newInstance();
                }
                catch (InstantiationException instantiationException) {
                }
                catch (IllegalAccessException illegalAccessException) {}
                this.sites[i][j].setCoordinate(new int[]{i, j}, this.basis);
                if (last != null) {
                    last.setNextSite(this.sites[i][j]);
                }
                last = this.sites[i][j];
                if (i > 0) {
                    last.setW(this.sites[i - 1][j]);
                }
                if (i == this.dimensions[0] - 1) {
                    last.setE(this.sites[0][j]);
                }
                if (j > 0) {
                    last.setN(this.sites[i][j - 1]);
                }
                if (j == this.dimensions[1] - 1) {
                    last.setS(this.sites[i][0]);
                }
                ++i;
            }
            ++j;
        }
        this.origin = this.sites[0][0];
        this.setNeighborIndexCutoff(0.06);
    }

    public final void clearOccupants() {
        Site s = this.origin;
        while (s != null) {
            s.setFirst(null);
            s = s.nextSite();
        }
    }

    public final int[] dimensions() {
        return this.dimensions;
    }

    public final Lattice.Occupant firstOccupant() {
        Site s = this.origin;
        Lattice.Occupant a = s.first();
        while (a == null) {
            if ((s = s.nextSite()) == null) {
                return null;
            }
            a = s.first();
        }
        return a;
    }

    public final double[][] getBasis() {
        return this.basis;
    }

    public final Site nearestSite(Space2D.Vector r) {
        int ix = (int)Math.floor(r.x * (double)this.dimensions[0]);
        int iy = (int)Math.floor(r.y * (double)this.dimensions[1]);
        return this.sites[ix][iy];
    }

    public final Site nearestSite(Space2D.Vector r, Space2D.Vector d) {
        int ix = (int)Math.floor(r.x / d.x * (double)this.dimensions[0]);
        int iy = (int)Math.floor(r.y / d.y * (double)this.dimensions[1]);
        return this.sites[ix][iy];
    }

    public final void setBasis(double[][] b) {
        this.basis = b;
    }

    public void setupNeighbors() {
        Site s1 = this.origin;
        while (s1 != null) {
            Site s2 = s1.nextSite();
            while (s2 != null) {
                if (s1.neighborIndex(s2, this.dimensions) < this.neighborIndexCutoff) {
                    s1.firstUpNeighbor = new Linker(s1.firstUpNeighbor, s2);
                    s2.firstDownNeighbor = new Linker(s2.firstDownNeighbor, s1);
                }
                s2 = s2.nextSite();
            }
            s1 = s1.nextSite();
        }
    }

    public final int siteCount() {
        return this.dimensions[0] * this.dimensions[1];
    }

    public final Site[][] sites() {
        return this.sites;
    }

    public static final class Linker {
        public final Linker next;
        public final Site site;

        public Linker(Linker n, Site s) {
            this.next = n;
            this.site = s;
        }

        public final Linker next() {
            return this.next;
        }

        public final Site site() {
            return this.site;
        }
    }

    public static class Site
    implements Lattice.Site {
        public Lattice.Occupant first;
        private Linker firstUpNeighbor;
        private Linker firstDownNeighbor;
        public final Color color = Constants.RandomColor();
        private Site nextSite;
        private Site previousSite;
        private int[] coordinate;
        Site n;
        Site e;
        Site s;
        Site w;

        public Site E() {
            return this.e;
        }

        public Site N() {
            return this.n;
        }

        public Site S() {
            return this.s;
        }

        public Site W() {
            return this.w;
        }

        public final int[] coordinate() {
            return this.coordinate;
        }

        public final Lattice.Occupant first() {
            return this.first;
        }

        public final Linker firstDownNeighbor() {
            return this.firstDownNeighbor;
        }

        public final Linker firstUpNeighbor() {
            return this.firstUpNeighbor;
        }

        public double neighborIndex(Lattice.Site ss, int[] dimensions) {
            Site s = (Site)ss;
            int dx = Math.abs(s.coordinate()[0] - this.coordinate[0]);
            int dy = Math.abs(s.coordinate()[1] - this.coordinate[1]);
            if (2 * dx > dimensions[0]) {
                dx -= dimensions[0];
            }
            if (2 * dy > dimensions[1]) {
                dy -= dimensions[1];
            }
            return dx * dx + dy * dy;
        }

        public final Site nextSite() {
            return this.nextSite;
        }

        public final Site previousSite() {
            return this.previousSite;
        }

        public void setCoordinate(int[] i, double[][] basis) {
            this.coordinate = i;
        }

        protected void setE(Site k) {
            this.e = k;
            k.w = this;
        }

        public final void setFirst(Lattice.Occupant o) {
            this.first = o;
        }

        protected void setN(Site k) {
            this.n = k;
            k.s = this;
        }

        public final void setNextSite(Site s) {
            this.nextSite = s;
            if (s != null) {
                s.previousSite = this;
            }
        }

        protected void setS(Site k) {
            this.s = k;
            k.n = this;
        }

        protected void setW(Site k) {
            this.w = k;
            k.e = this;
        }
    }

    public static class Point
    extends Site
    implements Lattice.Point {
        protected final double[] position = new double[2];

        public double neighborIndex(Lattice.Site s, int[] dimensions) {
            Point p = (Point)s;
            double dx = Math.abs(p.position()[0] - this.position[0]);
            double dy = Math.abs(p.position()[1] - this.position[1]);
            return (dx -= dx > 0.0 ? Math.floor(dx + 0.5) : Math.ceil(dx - 0.5)) * dx + (dy -= dy > 0.0 ? Math.floor(dy + 0.5) : Math.ceil(dy - 0.5)) * dy;
        }

        public final double[] position() {
            return this.position;
        }

        public void setCoordinate(int[] i, double[][] basis) {
            super.setCoordinate(i, basis);
            this.position[0] = (double)this.coordinate()[0] * basis[0][0] + (double)this.coordinate()[1] * basis[1][0];
            this.position[1] = (double)this.coordinate()[0] * basis[0][1] + (double)this.coordinate()[1] * basis[1][1];
        }
    }

    public static final class Cell
    extends Point
    implements Lattice.Cell {
        private final double[][] vertices = new double[][]{{0.5, 0.5}, {0.5, -0.5}, {-0.5, -0.5}, {-0.5, 0.5}};
        private final int nVertices = 4;
        private double volume;

        public boolean inCell(Atom a) {
            double x = a.coordinate.position().component(0);
            double y = a.coordinate.position().component(1);
            return 0.99999 * this.vertices[2][0] <= x && x <= 1.0000010000000001 * this.vertices[0][0] && 0.99999 * this.vertices[2][1] <= y && y <= 1.00001 * this.vertices[0][1];
        }

        public double neighborIndex(Lattice.Site s, int[] dimensions) {
            Cell c = (Cell)s;
            double r2Min = Double.MAX_VALUE;
            int k1 = 0;
            while (k1 < 4) {
                int k2 = 0;
                while (k2 < 4) {
                    double dx = Math.abs(c.vertices()[k1][0] - this.vertices[k2][0]);
                    double dy = Math.abs(c.vertices()[k1][1] - this.vertices[k2][1]);
                    r2Min = Math.min(r2Min, (dx -= dx > 0.0 ? Math.floor(dx + 0.5) : Math.ceil(dx - 0.5)) * dx + (dy -= dy > 0.0 ? Math.floor(dy + 0.5) : Math.ceil(dy - 0.5)) * dy);
                    ++k2;
                }
                ++k1;
            }
            return r2Min;
        }

        public void setCoordinate(int[] i, double[][] basis) {
            super.setCoordinate(i, basis);
            this.position[0] = this.position[0] + 0.5 * basis[0][0];
            this.position[1] = this.position[1] + 0.5 * basis[1][1];
            this.volume = basis[0][0] * basis[1][1];
            int k = 0;
            while (k < 4) {
                double[] dArray = this.vertices[k];
                dArray[0] = dArray[0] * basis[0][0];
                double[] dArray2 = this.vertices[k];
                dArray2[1] = dArray2[1] * basis[1][1];
                double[] dArray3 = this.vertices[k];
                dArray3[0] = dArray3[0] + this.position[0];
                double[] dArray4 = this.vertices[k];
                dArray4[1] = dArray4[1] + this.position[1];
                ++k;
            }
        }

        public double[][] vertices() {
            return this.vertices;
        }

        public double volume() {
            return this.volume;
        }
    }
}

