/*
 * Decompiled with CFR 0.152.
 */
package simulate;

import simulate.Configuration;
import simulate.Molecule;
import simulate.Space2D;
import simulate.Species;

public class ConfigurationSequential
extends Configuration {
    private boolean fill;

    public ConfigurationSequential() {
        this.setFillVertical(true);
    }

    public boolean getFillVertical() {
        return this.fill;
    }

    public void initializeCoordinates() {
        if (this.parentPhase == null) {
            return;
        }
        double Lx = this.parentPhase.dimensions().component(0);
        double Ly = this.parentPhase.dimensions().component(1);
        int sumOfMolecules = 0;
        int j = 0;
        while (j < this.species.size()) {
            Species.Agent s = (Species.Agent)this.species.elementAt(j);
            sumOfMolecules += s.getNMolecules();
            ++j;
        }
        if (sumOfMolecules == 0) {
            return;
        }
        Space2D.Vector[] rLat = Configuration.squareLattice(sumOfMolecules, Lx, Ly, this.fill);
        int i = 0;
        int j2 = 0;
        while (j2 < this.species.size()) {
            Species.Agent s = (Species.Agent)this.species.elementAt(j2);
            Molecule m = s.firstMolecule();
            while (m != s.terminationMolecule()) {
                m.setCOM(rLat[i]);
                ++i;
                m = m.nextMolecule();
            }
            ++j2;
        }
        this.initializeMomenta();
    }

    public void setFillVertical(boolean b) {
        this.fill = b;
    }
}

