/*
 * Decompiled with CFR 0.152.
 */
package simulate;

import simulate.Atom;
import simulate.AtomType;
import simulate.ConfigurationMolecule;
import simulate.Molecule;
import simulate.Space;
import simulate.Space2D;
import simulate.Species;

public class ConfigurationMoleculeLinear
extends ConfigurationMolecule {
    private double bondLength = 0.02;
    private Space.Vector orientation;
    private double theta = 45.0;

    protected void computeDimensions() {
        if (this.parentSpecies() == null) {
            return;
        }
        this.dim[1] = 0.0;
        Molecule m = this.parentSpecies().makeMolecule();
        this.initializeCoordinates(m);
        Atom a = m.firstAtom();
        while (a != m.terminationAtom()) {
            this.dim[1] = Math.max(this.dim[1], ((AtomType.Disk)a.type).diameter());
            a = a.nextAtom();
        }
        this.dim[0] = 0.5 * (((AtomType.Disk)m.firstAtom().type).diameter() + ((AtomType.Disk)m.lastAtom().type).diameter()) + (double)(m.nAtoms - 1) * this.bondLength;
    }

    public double getAngle() {
        return this.theta;
    }

    public double getBondLength() {
        return this.bondLength;
    }

    public void initializeCoordinates(Molecule m) {
        Space.Vector OldCOM = m.parentSpecies.parentSimulation.space.makeVector();
        OldCOM.E(m.COM());
        double xNext = 0.0;
        Atom a = m.firstAtom();
        while (a != m.terminationAtom()) {
            a.translateTo(OldCOM);
            a.translateBy(xNext, this.orientation);
            xNext += this.bondLength;
            a = a.nextAtom();
        }
        m.translateTo(OldCOM);
    }

    public void setAngle(double t) {
        this.theta = Math.PI * t / 180.0;
        this.setOrientation(new Space2D.Vector(Math.cos(this.theta), Math.sin(this.theta)));
    }

    public void setBondLength(double b) {
        this.bondLength = b;
        this.computeDimensions();
    }

    public void setOrientation(Space.Vector e) {
        this.orientation.E(e);
    }

    public void setParentSpecies(Species s) {
        this.parentSpecies = s;
        this.orientation = s.parentSimulation.space.makeVector();
        this.setAngle(this.theta);
        this.computeDimensions();
    }
}

