/*
 * Decompiled with CFR 0.152.
 */
package simulate;

import simulate.Atom;
import simulate.Molecule;
import simulate.Phase;
import simulate.Potential;
import simulate.Space;

public class AtomPair {
    public Atom atom1;
    public Atom atom2;
    public Space.CoordinatePair cPair;
    public Potential potential;

    public AtomPair() {
        this.cPair = null;
    }

    public AtomPair(Phase phase) {
        this.cPair = phase.space().makeCoordinatePair(phase.boundary());
    }

    public final Atom atom1() {
        return this.atom1;
    }

    public final Atom atom2() {
        return this.atom2;
    }

    public final double r2() {
        return this.cPair.r2();
    }

    public void reset() {
        this.cPair.reset(this.atom1.coordinate(), this.atom2.coordinate());
    }

    public void reset(Atom a1, Atom a2) {
        this.atom1 = a1;
        this.atom2 = a2;
        this.reset();
    }

    public void reset(Atom a1, Atom a2, Space.CoordinatePair cp) {
        this.atom1 = a1;
        this.atom2 = a2;
        this.cPair = cp;
    }

    public final double v2() {
        return this.cPair.v2();
    }

    public final double vDotr() {
        return this.cPair.vDotr();
    }

    public interface Iterator {
        public boolean hasNext();

        public AtomPair next();

        public void reset();

        public static interface M
        extends Iterator {
            public void reset(Molecule var1);
        }

        public static interface A
        extends Iterator {
            public void allDone();

            public void reset(Atom var1, boolean var2);
        }

        public static class All
        implements Iterator {
            private A apiUp;
            private A apiReserve;
            private final Atom.Iterator atomUp;
            private boolean intra;
            private boolean hasNext;
            private AtomPair thisPair;
            private AtomPair nextPair;

            public All(Phase p) {
                this.apiUp = p.iterator.makeAtomPairIteratorUp();
                this.apiReserve = p.iterator.makeAtomPairIteratorUp();
                this.atomUp = p.iterator.makeAtomIteratorUp();
                this.reset(true);
            }

            public boolean hasNext() {
                return this.hasNext;
            }

            public AtomPair next() {
                this.thisPair = this.apiUp.next();
                if (!this.apiUp.hasNext()) {
                    do {
                        if (!this.atomUp.hasNext()) {
                            this.hasNext = false;
                            return this.thisPair;
                        }
                        this.apiReserve.reset(this.atomUp.next(), this.intra);
                    } while (!this.apiReserve.hasNext());
                    A temp = this.apiUp;
                    this.apiUp = this.apiReserve;
                    this.apiReserve = temp;
                }
                return this.thisPair;
            }

            public void reset() {
                this.reset(this.intra);
            }

            public void reset(boolean i) {
                this.intra = i;
                this.atomUp.reset();
                do {
                    if (!this.atomUp.hasNext()) {
                        this.hasNext = false;
                        return;
                    }
                    this.apiUp.reset(this.atomUp.next(), this.intra);
                } while (!this.apiUp.hasNext());
                this.nextPair = this.apiUp.next();
                this.hasNext = true;
            }
        }

        public static class MP
        implements M {
            private final A apiUp;
            private final A apiDown;
            private A apiCurrent;
            private boolean hasNext;
            private boolean upDone;
            private AtomPair nextPair;
            private AtomPair thisPair;

            public MP(Phase p) {
                this.apiUp = p.iterator.makeAtomPairIteratorUp();
                this.apiDown = p.iterator.makeAtomPairIteratorDown();
                this.hasNext = false;
            }

            public MP(Phase p, Molecule m) {
                this.apiUp = p.iterator.makeAtomPairIteratorUp();
                this.apiDown = p.iterator.makeAtomPairIteratorDown();
                this.reset(m);
            }

            public boolean hasNext() {
                return this.hasNext;
            }

            public AtomPair next() {
                this.thisPair = this.apiCurrent.next();
                if (!this.apiCurrent.hasNext()) {
                    if (this.upDone) {
                        this.hasNext = false;
                    } else {
                        this.apiCurrent = this.apiDown;
                        this.upDone = true;
                        this.hasNext = this.apiCurrent.hasNext();
                    }
                }
                return this.thisPair;
            }

            public void reset() {
                System.out.println("reset in AtomPair.Iterator.MP is not implemented");
            }

            public void reset(Molecule m) {
                this.apiUp.reset(m.lastAtom(), false);
                this.apiDown.reset(m.firstAtom(), false);
                if (this.apiUp.hasNext()) {
                    this.apiCurrent = this.apiUp;
                    this.upDone = false;
                } else {
                    this.apiCurrent = this.apiDown;
                    this.upDone = true;
                }
                this.hasNext = this.apiCurrent.hasNext();
            }
        }

        public static final class Up
        implements A {
            private final AtomPair pair;
            private final Phase phase;
            private boolean hasNext;
            private Atom nextAtom;

            public Up(Phase p) {
                this.phase = p;
                this.pair = new AtomPair(p);
                this.hasNext = false;
            }

            public Up(Phase p, Atom a) {
                this.phase = p;
                this.pair = new AtomPair(p);
                this.reset(a, true);
            }

            public void allDone() {
                this.hasNext = false;
            }

            public boolean hasNext() {
                return this.hasNext;
            }

            public AtomPair next() {
                this.pair.atom2 = this.nextAtom;
                this.pair.reset();
                this.nextAtom = this.nextAtom.nextAtom();
                this.hasNext = this.nextAtom != null;
                return this.pair;
            }

            public void reset() {
                System.out.println("error in APIup");
            }

            public void reset(Atom a, boolean intra) {
                if (a == null || a.parentPhase() != this.phase) {
                    this.hasNext = false;
                    return;
                }
                this.pair.atom1 = a;
                this.nextAtom = intra ? a.nextAtom() : a.nextMoleculeFirstAtom();
                this.hasNext = this.nextAtom != null;
            }
        }

        public static final class Down
        implements A {
            private final AtomPair pair;
            private final Phase phase;
            private boolean hasNext;
            private Atom nextAtom;

            public Down(Phase p) {
                this.phase = p;
                this.pair = new AtomPair(p);
                this.hasNext = false;
            }

            public Down(Phase p, Atom a) {
                this.phase = p;
                this.pair = new AtomPair(p);
                this.reset(a, true);
            }

            public void allDone() {
                this.hasNext = false;
            }

            public boolean hasNext() {
                return this.hasNext;
            }

            public AtomPair next() {
                this.pair.atom2 = this.nextAtom;
                this.pair.reset();
                this.nextAtom = this.nextAtom.previousAtom();
                this.hasNext = this.nextAtom != null;
                return this.pair;
            }

            public void reset() {
                System.out.println("error in APIdown");
            }

            public void reset(Atom a, boolean intra) {
                if (a == null) {
                    this.hasNext = false;
                    return;
                }
                this.pair.atom1 = a;
                this.nextAtom = a.parentPhase() == this.phase ? (intra ? a.previousAtom() : a.previousMoleculeLastAtom()) : this.phase.lastAtom();
                this.hasNext = this.nextAtom != null;
            }
        }
    }
}

