/*
 * Decompiled with CFR 0.152.
 */
package simulate;

import simulate.Constants;
import simulate.IntegrationIntervalEvent;
import simulate.Meter;
import simulate.Space2D;

public class MeterPressureBoundary
extends Meter {
    private final double vScale = Constants.SCALE * Constants.SCALE * Constants.SCALE;
    private double momentumSum = 0.0;
    private double timeSum = 0.0;

    public MeterPressureBoundary() {
        this.setLabel("Pressure (bar)");
    }

    public double currentValue() {
        Space2D.BoundaryHard bnd = (Space2D.BoundaryHard)this.phase.boundary;
        double flux = bnd.pAccumulator * Constants.SCALE / this.timeSum;
        flux /= 2.0 * (bnd.dimensions.x + bnd.dimensions.y) * Constants.SCALE * Constants.DEPTH;
        this.timeSum = 0.0;
        bnd.pAccumulator = 0.0;
        return flux /= 0.0060220000000000004;
    }

    public void integrationIntervalAction(IntegrationIntervalEvent evt) {
        this.timeSum += evt.integrator.drawTimeStep * (double)evt.integrator.integrationInterval;
        this.updateStatistics(this.phase);
    }
}

