/*
 * Decompiled with CFR 0.152.
 */
package montecarlo;

public class Histogram {
    private double deltaX;
    private double xMin;
    private double xMax;
    private int nValues;
    private int sum;
    private int[] counts;
    private double[] histogram;
    private double[] xvalues;
    private Plot plot;

    public Histogram(int n, double d, double d2) {
        this.nValues = n;
        this.xMin = d;
        this.xMax = d2;
        this.counts = new int[this.nValues];
        this.histogram = new double[this.nValues];
        this.xvalues = new double[n];
        this.deltaX = (d2 - d) / (double)this.nValues;
        this.reset();
    }

    public void addValue(double d) {
        int n = (int)Math.floor((d - this.xMin) / this.deltaX);
        n = n >= this.nValues ? this.nValues - 1 : n;
        int n2 = n = n < 0 ? 0 : n;
        this.counts[n2] = this.counts[n2] + 1;
        ++this.sum;
    }

    public void addValues(double[] dArray) {
        int n = 0;
        while (n < dArray.length) {
            this.addValue(dArray[n]);
            ++n;
        }
    }

    public double[] getHistogram() {
        if (this.sum == 0) {
            return this.histogram;
        }
        int n = 0;
        while (n < this.nValues) {
            this.histogram[n] = (double)this.counts[n] / ((double)this.sum * this.deltaX);
            ++n;
        }
        return this.histogram;
    }

    public Plot getPlot() {
        if (this.plot == null) {
            this.plot = new Plot();
        }
        return this.plot;
    }

    public double[] getX() {
        return this.xvalues;
    }

    public void reset() {
        this.sum = 0;
        int n = 0;
        while (n < this.nValues) {
            this.histogram[n] = 0.0;
            this.counts[n] = 0;
            this.xvalues[n] = this.xMin + ((double)n + 0.5) * this.deltaX;
            ++n;
        }
    }

    public class Plot
    extends ptolemy.plot.Plot {
        public Plot() {
            this.setTitle("Histogram");
            this.setYRange(0.0, 1.0);
            this.setXRange(Histogram.this.xMin, Histogram.this.xMax);
            this.setImpulses(true);
            this.setMarksStyle("none");
            this.update();
        }

        public void update() {
            this.clear(false);
            this.repaint();
            double[] dArray = Histogram.this.getHistogram();
            double[] dArray2 = Histogram.this.getX();
            int n = 0;
            while (n < dArray.length) {
                this.addPoint(0, dArray2[n], dArray[n], false);
                ++n;
            }
            this.repaint();
        }
    }
}

