/*
 * Decompiled with CFR 0.152.
 */
package simulate;

import java.awt.Panel;
import simulate.Atom;
import simulate.AtomPair;
import simulate.Controller;
import simulate.Display;
import simulate.Integrator;
import simulate.P1Null;
import simulate.P2IdealGas;
import simulate.Phase;
import simulate.Potential;
import simulate.Potential1;
import simulate.Potential2;
import simulate.Space;
import simulate.Species;
import simulate.units.UnitSystem;

public class Simulation
extends Panel {
    public static int D;
    public static Space space;
    private static UnitSystem unitSystem;
    public Controller controller;
    Phase firstPhase;
    Phase lastPhase;
    Display firstDisplay;
    Display lastDisplay;
    int speciesCount = 0;
    public Potential2[][] potential2;
    public Potential1[] potential1;
    Species firstSpecies;
    Species lastSpecies;
    private Potential1 p1Null = new P1Null();
    private Potential2 p2IdealGas = new P2IdealGas();

    public Simulation(Space s) {
        space = s;
        D = space.D();
        Simulation.setUnitSystem(new UnitSystem.Sim());
        this.setSize(400, 300);
    }

    public void add(Controller c) {
        if (this.controller != null) {
            return;
        }
        super.add(c);
        this.controller = c;
        c.parentSimulation = this;
    }

    public void add(Display d) {
        super.add(d);
        this.addDisplay(d);
    }

    public void add(Phase p) {
        p.initialize(this);
        if (this.lastPhase != null) {
            this.lastPhase.setNextPhase(p);
        } else {
            this.firstPhase = p;
        }
        this.lastPhase = p;
        if (this.hasIntegrator()) {
            this.controller.integrator().registerPhase(p);
            p.gravity.addObserver(this.controller.integrator());
            p.integrator = this.controller.integrator();
        }
        Display d = this.firstDisplay;
        while (d != null) {
            d.setPhase(p);
            d = d.nextDisplay();
        }
        Species s = this.firstSpecies;
        while (s != null) {
            p.add(s.makeAgent(p));
            s = s.nextSpecies();
        }
    }

    public void add(Potential1 p1) {
        super.add(p1);
        p1.setSimulation(this);
        if (p1.speciesIndex + 1 > this.speciesCount) {
            this.setSpeciesCount(p1.speciesIndex + 1);
        }
        this.potential1[p1.speciesIndex] = p1;
    }

    public void add(Potential2 p2) {
        super.add(p2);
        p2.setSimulation(this);
        int idx = Math.max(p2.species1Index, p2.species2Index);
        if (idx + 1 > this.speciesCount) {
            this.setSpeciesCount(idx + 1);
        }
        this.potential2[p2.species1Index][p2.species2Index] = p2;
        this.potential2[p2.species2Index][p2.species1Index] = p2;
    }

    public void add(Species species) {
        species.parentSimulation = this;
        if (this.lastSpecies != null) {
            this.lastSpecies.setNextSpecies(species);
        } else {
            this.firstSpecies = species;
        }
        this.lastSpecies = species;
        if (species.getSpeciesIndex() > this.speciesCount - 1) {
            this.setSpeciesCount(species.getSpeciesIndex() + 1);
        }
        species.setNMolecules(species.getNMolecules());
        species.add(species.colorScheme);
        species.add(species.configurationMolecule);
        Phase p = this.firstPhase;
        while (p != null) {
            p.add(species.makeAgent(p));
            p = p.nextPhase();
        }
    }

    public void addDisplay(Display d) {
        d.parentSimulation = this;
        if (this.lastDisplay != null) {
            this.lastDisplay.setNextDisplay(d);
        } else {
            this.firstDisplay = d;
        }
        this.lastDisplay = d;
        if (this.hasIntegrator()) {
            this.controller.integrator().addIntegrationIntervalListener(d);
        }
        Phase p = this.firstPhase;
        while (p != null) {
            d.setPhase(p);
            p = p.nextPhase();
        }
        d.repaint();
    }

    public final Display firstDisplay() {
        return this.firstDisplay;
    }

    public final Phase firstPhase() {
        return this.firstPhase;
    }

    public final Species firstSpecies() {
        return this.firstSpecies;
    }

    public int getD() {
        return space.D();
    }

    public Potential getPotential(AtomPair pair) {
        Atom a2;
        Atom a1 = pair.atom1();
        if (a1 == (a2 = pair.atom2())) {
            return pair.atom1().parentPhase().potential();
        }
        if (a1.parentMolecule() == a2.parentMolecule()) {
            return this.potential1[a1.speciesIndex()].getPotential(a1, a2);
        }
        return this.potential2[a2.speciesIndex()][a1.speciesIndex()].getPotential(a1, a2);
    }

    public boolean hasIntegrator() {
        return this.controller != null && this.controller.integrator() != null;
    }

    public Integrator integrator() {
        if (this.controller == null) {
            return null;
        }
        return this.controller.integrator();
    }

    public final Display lastDisplay() {
        return this.lastDisplay;
    }

    public final Phase lastPhase() {
        return this.lastPhase;
    }

    public final Species lastSpecies() {
        return this.lastSpecies;
    }

    private void setSpeciesCount(int n) {
        Potential1[] p1 = new Potential1[n];
        Potential2[][] p2 = new Potential2[n][n];
        int i = 0;
        while (i < this.speciesCount) {
            p1[i] = this.potential1[i];
            p2[i][i] = this.potential2[i][i];
            int j = i + 1;
            while (j < this.speciesCount) {
                Potential2 potential2 = this.potential2[i][j];
                p2[j][i] = potential2;
                p2[i][j] = potential2;
                ++j;
            }
            ++i;
        }
        int i2 = this.speciesCount;
        while (i2 < n) {
            p1[i2] = this.p1Null;
            p2[i2][i2] = this.p2IdealGas;
            int j = 0;
            while (j < n) {
                Potential2 potential2 = this.p2IdealGas;
                p2[j][i2] = potential2;
                p2[i2][j] = potential2;
                ++j;
            }
            ++i2;
        }
        this.potential1 = p1;
        this.potential2 = p2;
        this.speciesCount = n;
    }

    public static final void setUnitSystem(UnitSystem us) {
        unitSystem = us;
    }

    public static Space space() {
        return space;
    }

    public static final UnitSystem unitSystem() {
        return unitSystem;
    }
}

