/*
 * Decompiled with CFR 0.152.
 */
package simulate;

import java.util.Random;
import simulate.Default;
import simulate.MCMove;
import simulate.Phase;
import simulate.Simulation;
import simulate.units.Unit;

public class MCMoveVolume
extends MCMove {
    private final Random rand = new Random();
    protected double pressure;
    protected Unit.Pressure pressureUnit;

    public MCMoveVolume() {
        this.setStepSizeMax(1.0);
        this.setStepSizeMin(0.0);
        this.setStepSize(0.1);
        this.setPressure(1.0, Default.PRESSURE_UNIT);
    }

    public final double getPressure() {
        return this.pressureUnit.fromSim(this.pressure);
    }

    public Unit.Pressure getPressureUnit() {
        return this.pressureUnit;
    }

    public final double pressure() {
        return this.pressure;
    }

    public final void setLogPressure(int lp) {
        this.setPressure(Math.pow(10.0, lp));
    }

    public void setPressure(double p) {
        this.pressure = this.pressureUnit.toSim(p);
    }

    public final void setPressure(double p, Unit.Pressure u) {
        this.pressureUnit = u;
        this.setPressure(p);
    }

    public final void setPressureUnit(Unit.Pressure u) {
        this.pressureUnit = u;
    }

    public void thisTrial(Phase phase) {
        double vOld = phase.volume();
        double hOld = phase.potentialEnergy.currentValue() + this.pressure * vOld;
        double vScale = (2.0 * this.rand.nextDouble() - 1.0) * this.stepSize;
        double vNew = vOld * Math.exp(vScale);
        double rScale = Math.exp(vScale / (double)Simulation.D);
        phase.inflate(rScale);
        double hNew = phase.potentialEnergy.currentValue() + this.pressure * vNew;
        if (hNew >= Double.MAX_VALUE || Math.exp(-(hNew - hOld) / this.parentIntegrator.temperature + (double)(phase.moleculeCount + 1) * vScale) < this.rand.nextDouble()) {
            phase.inflate(1.0 / rScale);
        }
        ++this.nAccept;
    }
}

