/*
 * Decompiled with CFR 0.152.
 */
package simulate;

import java.awt.Container;
import java.io.Serializable;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import simulate.Atom;
import simulate.Controller;
import simulate.Default;
import simulate.IntegrationIntervalEvent;
import simulate.IntegrationIntervalListener;
import simulate.Meter;
import simulate.Phase;
import simulate.Simulation;
import simulate.units.Unit;

public abstract class Integrator
extends Container
implements Observer,
Serializable,
Runnable {
    public Thread runner;
    public boolean running = false;
    protected int maxSteps = Integer.MAX_VALUE;
    Phase firstPhase;
    Phase[] phase;
    int phaseCount = 0;
    int phaseCountMax = 1;
    protected int sleepPeriod = 10;
    protected transient Vector listeners = null;
    private Vector integrationIntervalListeners = new Vector();
    int integrationInterval = 10;
    int integrationCount = 0;
    double drawTimeStep = 5.0E-4;
    boolean doSleep = true;
    boolean paused = false;
    public Controller parentController;
    public Integrator nextIntegrator = null;
    protected double temperature;
    protected Unit.Temperature temperatureUnit;
    protected boolean isothermal = false;

    public Integrator() {
        this.phase = new Phase[this.phaseCountMax];
        this.runner = new Thread(this);
        this.setTemperature(300.0, Default.TEMPERATURE_UNIT);
    }

    public synchronized void addIntegrationIntervalListener(IntegrationIntervalListener iil) {
        this.integrationIntervalListeners.addElement(iil);
    }

    protected void deployAgents() {
        Phase p = this.firstPhase;
        while (p != null) {
            Atom a = p.firstAtom();
            while (a != null) {
                a.setIntegratorAgent(this.makeAgent(a));
                a = a.nextAtom();
            }
            p = p.nextPhase();
        }
    }

    public abstract void doStep();

    protected synchronized void doWait() {
        try {
            this.wait();
        }
        catch (InterruptedException interruptedException) {}
    }

    public void fireIntegrationIntervalEvent(IntegrationIntervalEvent iie) {
        Vector currentListeners = null;
        Integrator integrator = this;
        synchronized (integrator) {
            currentListeners = (Vector)this.integrationIntervalListeners.clone();
        }
        int i = 0;
        while (i < currentListeners.size()) {
            IntegrationIntervalListener listener = (IntegrationIntervalListener)currentListeners.elementAt(i);
            listener.integrationIntervalAction(iie);
            ++i;
        }
    }

    public final double getDrawTimeStep() {
        return this.drawTimeStep;
    }

    public final int getIntegrationInterval() {
        return this.integrationInterval;
    }

    public int getMaxSteps() {
        return this.maxSteps;
    }

    public final int getSleepPeriod() {
        return this.sleepPeriod;
    }

    public final double getTemperature() {
        return this.temperatureUnit.fromSim(this.temperature);
    }

    public Unit.Temperature getTemperatureUnit() {
        return this.temperatureUnit;
    }

    public abstract void initialize();

    public boolean isDoSleep() {
        return this.doSleep;
    }

    public boolean isIsothermal() {
        return this.isothermal;
    }

    public abstract Agent makeAgent(Atom var1);

    public void pause() {
        this.paused = true;
    }

    public void registerPhase(Phase p) {
        if (!this.wantsPhase()) {
            return;
        }
        int i = 0;
        while (i < this.phaseCount) {
            if (this.phase[i] == p) {
                return;
            }
            ++i;
        }
        this.phase[this.phaseCount] = p;
        ++this.phaseCount;
        this.firstPhase = this.phase[0];
        Meter m = p.firstMeter;
        while (m != null) {
            this.addIntegrationIntervalListener(m);
            m = m.nextMeter();
        }
    }

    public synchronized void removeIntegrationIntervalListener(IntegrationIntervalListener iil) {
        this.integrationIntervalListeners.removeElement(iil);
    }

    /*
     * Unable to fully structure code
     */
    public void run() {
        ic = false;
        nSteps = 0;
        iieCount = this.integrationInterval;
        ** GOTO lbl18
        {
            this.doWait();
            do {
                if (this.paused) continue block2;
                this.doStep();
                if (--iieCount == 0) {
                    this.fireIntegrationIntervalEvent(new IntegrationIntervalEvent(this, this.firstPhase));
                    iieCount = this.integrationInterval;
                }
                if (this.doSleep) {
                    try {
                        Thread.sleep(this.sleepPeriod);
                    }
                    catch (InterruptedException v0) {}
                }
                ++nSteps;
lbl18:
                // 2 sources

            } while (nSteps < this.maxSteps);
        }
        System.exit(0);
    }

    public void setController(Controller c) {
        this.parentController = c;
    }

    public void setDoSleep(boolean b) {
        this.doSleep = b;
    }

    public final void setDrawTimeStep(double t) {
        this.drawTimeStep = t;
    }

    public final void setIntegrationInterval(int interval) {
        this.integrationInterval = interval;
    }

    public void setIsothermal(boolean b) {
        this.isothermal = b;
    }

    public void setMaxSteps(int m) {
        this.maxSteps = m;
    }

    public final void setSleepPeriod(int s) {
        this.sleepPeriod = s;
    }

    public final void setTemperature(double t) {
        this.temperature = this.temperatureUnit.toSim(t);
    }

    public final void setTemperature(double t, Unit.Temperature u) {
        this.temperatureUnit = u;
        this.setTemperature(t);
    }

    public final void setTemperatureUnit(Unit.Temperature u) {
        this.temperatureUnit = u;
    }

    public final Simulation simulation() {
        return this.parentController.parentSimulation;
    }

    public void start() {
        this.initialize();
        this.runner.start();
    }

    public void stop() {
        if (this.runner != null) {
            this.runner.stop();
            this.runner = null;
        }
    }

    public final double temperature() {
        return this.temperature;
    }

    public synchronized void unPause() {
        this.paused = false;
        this.notify();
    }

    public void update(Observable o, Object arg) {
    }

    public boolean wantsPhase() {
        return this.phaseCount < this.phaseCountMax;
    }

    static interface Agent {
    }
}

