/*
 * Decompiled with CFR 0.152.
 */
package montecarlo;

import java.util.Random;
import montecarlo.Function;
import montecarlo.MyRandom;

public class Quadrature {
    private Function integrand;
    private double xMin;
    private double xMax;
    private double[] x;
    private int nPoints;

    public Quadrature(Function i) {
        this.setFunction(i);
        this.setN(20);
        this.setXMin(0.0);
        this.setXMax(1.0);
    }

    public int getN() {
        return this.nPoints;
    }

    public double[] getX() {
        return this.x;
    }

    public double getXMax() {
        return this.xMax;
    }

    public double getXMin() {
        return this.xMin;
    }

    public double importanceMC(int n, Random rand, Function w) {
        this.setN(n);
        return this.importanceMC(rand, w);
    }

    public double importanceMC(Random rand, Function w) {
        double deltaX = this.xMax - this.xMin;
        double sum = 0.0;
        int i = 0;
        while (i < this.nPoints) {
            this.x[i] = this.xMin + deltaX * rand.nextDouble();
            sum += this.integrand.f(this.x[i]) / w.f(this.x[i]);
            ++i;
        }
        return sum * deltaX / (double)this.nPoints;
    }

    public double rectangle() {
        double deltaX = (this.xMax - this.xMin) / (double)this.nPoints;
        double sum = 0.0;
        int i = 0;
        while (i < this.nPoints) {
            this.x[i] = this.xMin + ((double)i + 0.5) * deltaX;
            sum += this.integrand.f(this.x[i]);
            ++i;
        }
        return sum * deltaX;
    }

    public double rectangle(int n) {
        this.setN(n);
        return this.rectangle();
    }

    public void setFunction(Function i) {
        this.integrand = i;
    }

    public void setN(int n) {
        this.nPoints = n;
        this.x = new double[this.nPoints];
    }

    public void setXMax(double xmax) {
        this.xMax = xmax;
    }

    public void setXMin(double xmin) {
        this.xMin = xmin;
    }

    public double simpleMC() {
        MyRandom rand = new MyRandom();
        double deltaX = this.xMax - this.xMin;
        double sum = 0.0;
        int i = 0;
        while (i < this.nPoints) {
            this.x[i] = this.xMin + deltaX * ((Random)rand).nextDouble();
            sum += this.integrand.f(this.x[i]);
            ++i;
        }
        return sum * deltaX / (double)this.nPoints;
    }

    public double simpleMC(int n) {
        this.setN(n);
        return this.simpleMC();
    }

    public double trapezoid() {
        double deltaX = (this.xMax - this.xMin) / ((double)this.nPoints - 1.0);
        double sum = 0.0;
        int i = 0;
        while (i < this.nPoints) {
            this.x[i] = this.xMin + (double)i * deltaX;
            sum += i == 0 || i == this.nPoints - 1 ? 0.5 * this.integrand.f(this.x[i]) : this.integrand.f(this.x[i]);
            ++i;
        }
        return sum * deltaX;
    }

    public double trapezoid(int n) {
        this.setN(n);
        return this.trapezoid();
    }
}

