/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.plot;

import java.awt.Button;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.NumberFormat;
import java.util.Enumeration;
import java.util.Vector;

public class PlotBox
extends Panel {
    protected transient double _yMax;
    protected transient double _yMin;
    protected transient double _xMax;
    protected transient double _xMin;
    protected static final transient double _PADDING = 0.05;
    protected transient boolean _xRangeGiven = false;
    protected transient boolean _yRangeGiven = false;
    protected double _xBottom = Double.MAX_VALUE;
    protected double _xTop = -1.7976931348623157E308;
    protected double _yBottom = Double.MAX_VALUE;
    protected double _yTop = -1.7976931348623157E308;
    protected boolean _xlog = false;
    protected boolean _ylog = false;
    protected static final double _LOG10SCALE = 1.0 / Math.log(10.0);
    protected boolean _grid = true;
    protected Color _background = Color.white;
    protected Color _foreground = Color.black;
    protected int _topPadding = 10;
    protected int _bottomPadding = 5;
    protected int _rightPadding = 10;
    protected int _leftPadding = 10;
    protected int _ulx = 1;
    protected int _uly = 1;
    protected int _lrx = 100;
    protected int _lry = 100;
    protected double _yscale = 1.0;
    protected double _xscale = 1.0;
    protected boolean _usecolor = true;
    protected static Color[] _colors = new Color[]{new Color(153, 0, 0), new Color(255), new Color(43690), new Color(0), new Color(16753920), new Color(5473931), new Color(16744272), new Color(4565791), new Color(9454125), new Color(0xA0A0A0), new Color(0x14FF14)};
    protected int _width = 400;
    protected int _height = 400;
    protected URL _documentBase;
    private String _filespec;
    private double _xlowgiven;
    private double _xhighgiven;
    private double _ylowgiven;
    private double _yhighgiven;
    private boolean _binary = false;
    private double _ytickMax;
    private double _ytickMin;
    private double _xtickMax;
    private double _xtickMin;
    private int _yExp;
    private int _xExp;
    private double _ytickscale;
    private double _xtickscale;
    private Font _labelfont;
    private Font _superscriptfont;
    private Font _titlefont;
    private FontMetrics _labelFontMetrics;
    private FontMetrics _superscriptFontMetrics;
    private FontMetrics _titleFontMetrics;
    private transient NumberFormat _numberFormat;
    private transient int _gridCurJuke;
    private transient double _gridBase;
    private transient String[] _errorMsg;
    private String _xlabel;
    private String _ylabel;
    private String _title;
    private Vector _legendStrings = new Vector();
    private Vector _legendDatasets = new Vector();
    private Vector _xticks;
    private Vector _xticklabels;
    private Vector _yticks;
    private Vector _yticklabels;
    private transient Button _fillButton;
    private transient int _zoomx = -1;
    private transient int _zoomy = -1;
    private transient int _zoomxn = -1;
    private transient int _zoomyn = -1;
    private transient boolean _zoomin = false;
    private transient boolean _zoomout = false;
    private transient boolean _drawn = false;
    boolean doYTicks = true;

    public PlotBox() {
        this.setLayout(new FlowLayout(2));
        this.addMouseListener(new ZoomListener());
        this.addMouseMotionListener(new DragListener());
        this._measureFonts();
    }

    private int _drawLegend(Graphics graphics, int urx, int ury) {
        graphics.setFont(this._labelfont);
        int spacing = this._labelFontMetrics.getHeight();
        Enumeration v = this._legendStrings.elements();
        Enumeration i = this._legendDatasets.elements();
        int ypos = ury + spacing;
        int maxwidth = 0;
        while (v.hasMoreElements()) {
            String legend = (String)v.nextElement();
            int dataset = (Integer)i.nextElement();
            if (dataset < 0) continue;
            if (this._usecolor) {
                int color = dataset % _colors.length;
                graphics.setColor(_colors[color]);
            }
            this._drawPoint(graphics, dataset, urx - 3, ypos - 3, false);
            graphics.setColor(this._foreground);
            int width = this._labelFontMetrics.stringWidth(legend);
            if (width > maxwidth) {
                maxwidth = width;
            }
            graphics.drawString(legend, urx - 15 - width, ypos);
            ypos += spacing;
        }
        return 22 + maxwidth;
    }

    protected synchronized void _drawPlot(Graphics graphics, boolean clearfirst) {
        if (graphics == null) {
            throw new RuntimeException("PlotBox._drawPlot: Attempt to draw axes without a Graphics object.");
        }
        Rectangle drawRect = this.getBounds();
        graphics.setPaintMode();
        if (clearfirst) {
            graphics.clearRect(0, 0, drawRect.width, drawRect.height);
        }
        if (this._errorMsg != null) {
            int fheight;
            int msgy = fheight = this._labelFontMetrics.getHeight() + 2;
            graphics.setColor(Color.black);
            int i = 0;
            while (i < this._errorMsg.length) {
                graphics.drawString(this._errorMsg[i], 10, msgy);
                msgy += fheight;
                System.err.println(this._errorMsg[i]);
                ++i;
            }
            return;
        }
        if (!this._xRangeGiven) {
            if (this._xBottom > this._xTop) {
                this._setXRange(0.0, 0.0);
            } else {
                this._setXRange(this._xBottom, this._xTop);
            }
        }
        if (!this._yRangeGiven) {
            if (this._yBottom > this._yTop) {
                this._setYRange(0.0, 0.0);
            } else {
                this._setYRange(this._yBottom, this._yTop);
            }
        }
        int titley = 0;
        int titlefontheight = this._titleFontMetrics.getHeight();
        if (this._title == null) {
            this._title = "";
        }
        if (this._title != null || this._yExp != 0) {
            titley = titlefontheight + this._topPadding;
        }
        graphics.setFont(this._labelfont);
        int labelheight = this._labelFontMetrics.getHeight();
        int halflabelheight = labelheight / 2;
        int ySPos = drawRect.height - 5;
        int xSPos = drawRect.width - this._rightPadding;
        if (this._xlog) {
            this._xExp = (int)Math.floor(this._xtickMin);
        }
        if (this._xExp != 0 && this._xticks == null) {
            String superscript = Integer.toString(this._xExp);
            xSPos -= this._superscriptFontMetrics.stringWidth(superscript);
            graphics.setFont(this._superscriptfont);
            if (!this._xlog) {
                graphics.drawString(superscript, xSPos, ySPos - halflabelheight);
                graphics.setFont(this._labelfont);
                graphics.drawString("x10", xSPos -= this._labelFontMetrics.stringWidth("x10"), ySPos);
            }
            this._bottomPadding = 3 * labelheight / 2 + 5;
        }
        if (this._xlabel != null && this._bottomPadding < labelheight + 5) {
            this._bottomPadding = titlefontheight + 5;
        }
        this._uly = titley + 5;
        this._lry = drawRect.height - labelheight - this._bottomPadding - 3;
        int height = this._lry - this._uly;
        this._yscale = (double)height / (this._yMax - this._yMin);
        this._ytickscale = (double)height / (this._ytickMax - this._ytickMin);
        int ny = 2 + height / (labelheight + 10);
        double yStep = this._roundUp((this._ytickMax - this._ytickMin) / (double)ny);
        double yStart = yStep * Math.ceil(this._ytickMin / yStep);
        int widesty = 0;
        String[] ylabels = new String[ny];
        int[] ylabwidth = new int[ny];
        int ind = 0;
        if (this._yticks == null) {
            Vector ygrid = null;
            if (this._ylog) {
                ygrid = this._gridInit(yStart, yStep, true, null);
            }
            int numfracdigits = this._numFracDigits(yStep);
            double yTmpStart = yStart;
            if (this._ylog) {
                yTmpStart = this._gridStep(ygrid, yStart, yStep, this._ylog);
            }
            double ypos = yTmpStart;
            while (ypos <= this._ytickMax) {
                if (ind < ny) {
                    String yticklabel = this._ylog ? this._formatLogNum(ypos, numfracdigits) : this._formatNum(ypos, numfracdigits);
                    ylabels[ind] = yticklabel;
                    int lw = this._labelFontMetrics.stringWidth(yticklabel);
                    ylabwidth[ind++] = lw;
                    if (lw > widesty) {
                        widesty = lw;
                    }
                    ypos = this._gridStep(ygrid, ypos, yStep, this._ylog);
                    continue;
                }
                break;
            }
        } else {
            Enumeration nl = this._yticklabels.elements();
            while (nl.hasMoreElements()) {
                String label = (String)nl.nextElement();
                int lw = this._labelFontMetrics.stringWidth(label);
                if (lw <= widesty) continue;
                widesty = lw;
            }
        }
        this._ulx = this._ylabel != null ? widesty + this._labelFontMetrics.stringWidth("W") + this._leftPadding : widesty + this._leftPadding;
        int legendwidth = this._drawLegend(graphics, drawRect.width - this._rightPadding, this._uly);
        this._lrx = drawRect.width - legendwidth - this._rightPadding;
        int width = this._lrx - this._ulx;
        this._xscale = (double)width / (this._xMax - this._xMin);
        this._xtickscale = (double)width / (this._xtickMax - this._xtickMin);
        graphics.setColor(Color.white);
        graphics.fillRect(this._ulx, this._uly, width, height);
        graphics.setColor(this._foreground);
        graphics.drawRect(this._ulx, this._uly, width, height);
        int tickLength = 5;
        int xCoord1 = this._ulx + tickLength;
        int xCoord2 = this._lrx - tickLength;
        if (this.doYTicks) {
            if (this._yticks == null) {
                Vector ygrid = null;
                double yTmpStart = yStart;
                if (this._ylog) {
                    ygrid = this._gridInit(yStart, yStep, true, null);
                    yTmpStart = this._gridStep(ygrid, yStart, yStep, this._ylog);
                    ny = ind;
                }
                ind = 0;
                boolean needExponent = this._ylog;
                double ypos = yTmpStart;
                while (ypos <= this._ytickMax) {
                    if (ind >= ny) break;
                    int yCoord1 = this._lry - (int)((ypos - this._ytickMin) * this._ytickscale);
                    int offset = 0;
                    if (ind > 0 && !this._ylog) {
                        offset = halflabelheight;
                    }
                    graphics.drawLine(this._ulx, yCoord1, xCoord1, yCoord1);
                    graphics.drawLine(this._lrx, yCoord1, xCoord2, yCoord1);
                    if (this._grid && yCoord1 != this._uly && yCoord1 != this._lry) {
                        graphics.setColor(Color.lightGray);
                        graphics.drawLine(xCoord1, yCoord1, xCoord2, yCoord1);
                        graphics.setColor(this._foreground);
                    }
                    if (this._ylog && ylabels[ind].indexOf(101) != -1) {
                        needExponent = false;
                    }
                    graphics.drawString(ylabels[ind], this._ulx - ylabwidth[ind++] - 4, yCoord1 + offset);
                    ypos = this._gridStep(ygrid, ypos, yStep, this._ylog);
                }
                if (this._ylog) {
                    Vector unlabeledgrid = this._gridInit(yStart, yStep, false, ygrid);
                    if (unlabeledgrid.size() > 0) {
                        double tmpStep = yStep > 1.0 ? 1.0 : yStep;
                        double ypos2 = this._gridStep(unlabeledgrid, yStart, tmpStep, this._ylog);
                        while (ypos2 <= this._ytickMax) {
                            int yCoord1 = this._lry - (int)((ypos2 - this._ytickMin) * this._ytickscale);
                            if (this._grid && yCoord1 != this._uly && yCoord1 != this._lry) {
                                graphics.setColor(Color.lightGray);
                                graphics.drawLine(this._ulx + 1, yCoord1, this._lrx - 1, yCoord1);
                                graphics.setColor(this._foreground);
                            }
                            ypos2 = this._gridStep(unlabeledgrid, ypos2, tmpStep, this._ylog);
                        }
                    }
                    this._yExp = needExponent ? (int)Math.floor(yTmpStart) : 0;
                }
                if (this._yExp != 0) {
                    graphics.drawString("x10", 2, titley);
                    graphics.setFont(this._superscriptfont);
                    graphics.drawString(Integer.toString(this._yExp), this._labelFontMetrics.stringWidth("x10") + 2, titley - halflabelheight);
                    graphics.setFont(this._labelfont);
                }
            } else {
                Enumeration nt = this._yticks.elements();
                Enumeration nl = this._yticklabels.elements();
                while (nl.hasMoreElements()) {
                    String label = (String)nl.nextElement();
                    double ypos = (Double)nt.nextElement();
                    if (ypos > this._yMax || ypos < this._yMin) continue;
                    int yCoord1 = this._lry - (int)((ypos - this._yMin) * this._yscale);
                    int offset = 0;
                    if (ypos < (double)(this._lry - labelheight)) {
                        offset = halflabelheight;
                    }
                    graphics.drawLine(this._ulx, yCoord1, xCoord1, yCoord1);
                    graphics.drawLine(this._lrx, yCoord1, xCoord2, yCoord1);
                    if (this._grid && yCoord1 != this._uly && yCoord1 != this._lry) {
                        graphics.setColor(Color.lightGray);
                        graphics.drawLine(xCoord1, yCoord1, xCoord2, yCoord1);
                        graphics.setColor(this._foreground);
                    }
                    graphics.drawString(label, this._ulx - this._labelFontMetrics.stringWidth(label) - 3, yCoord1 + offset);
                }
            }
        }
        int yCoord1 = this._uly + tickLength;
        int yCoord2 = this._lry - tickLength;
        if (this._xticks == null) {
            int nx = 10;
            double xStep = 0.0;
            int numfracdigits = 0;
            int charwidth = this._labelFontMetrics.stringWidth("8");
            if (this._xlog) {
                nx = 2 + width / (charwidth * 6 + 10);
            } else {
                int count = 0;
                while (count++ <= 10) {
                    int savenx;
                    int maxlabelwidth;
                    int inttemp;
                    xStep = this._roundUp((this._xtickMax - this._xtickMin) / (double)nx);
                    numfracdigits = this._numFracDigits(xStep);
                    int intdigits = this._numIntDigits(this._xtickMax);
                    if (intdigits < (inttemp = this._numIntDigits(this._xtickMin))) {
                        intdigits = inttemp;
                    }
                    if ((nx = 2 + width / ((maxlabelwidth = charwidth * (numfracdigits + 2 + intdigits)) + 10)) - (savenx = nx) <= 1 || savenx - nx <= 1) break;
                }
            }
            xStep = this._roundUp((this._xtickMax - this._xtickMin) / (double)nx);
            numfracdigits = this._numFracDigits(xStep);
            double xStart = xStep * Math.ceil(this._xtickMin / xStep);
            Vector xgrid = null;
            double xTmpStart = xStart;
            if (this._xlog) {
                xgrid = this._gridInit(xStart, xStep, true, null);
                xTmpStart = this._gridRoundUp(xgrid, xStart);
            }
            boolean needExponent = this._xlog;
            double xpos = xTmpStart;
            while (xpos <= this._xtickMax) {
                String xticklabel;
                if (this._xlog) {
                    xticklabel = this._formatLogNum(xpos, numfracdigits);
                    if (xticklabel.indexOf(101) != -1) {
                        needExponent = false;
                    }
                } else {
                    xticklabel = this._formatNum(xpos, numfracdigits);
                }
                xCoord1 = this._ulx + (int)((xpos - this._xtickMin) * this._xtickscale);
                graphics.drawLine(xCoord1, this._uly, xCoord1, yCoord1);
                graphics.drawLine(xCoord1, this._lry, xCoord1, yCoord2);
                if (this._grid && xCoord1 != this._ulx && xCoord1 != this._lrx) {
                    graphics.setColor(Color.lightGray);
                    graphics.drawLine(xCoord1, yCoord1, xCoord1, yCoord2);
                    graphics.setColor(this._foreground);
                }
                int labxpos = xCoord1 - this._labelFontMetrics.stringWidth(xticklabel) / 2;
                graphics.drawString(xticklabel, labxpos, this._lry + 3 + labelheight);
                xpos = this._gridStep(xgrid, xpos, xStep, this._xlog);
            }
            if (this._xlog) {
                double tmpStep = xStep > 1.0 ? 1.0 : xStep;
                xTmpStart = tmpStep * Math.ceil(this._xtickMin / tmpStep);
                Vector unlabeledgrid = this._gridInit(xTmpStart, tmpStep, false, xgrid);
                if (unlabeledgrid.size() > 0) {
                    double xpos2 = this._gridStep(unlabeledgrid, xTmpStart, tmpStep, this._xlog);
                    while (xpos2 <= this._xtickMax) {
                        xCoord1 = this._ulx + (int)((xpos2 - this._xtickMin) * this._xtickscale);
                        if (this._grid && xCoord1 != this._ulx && xCoord1 != this._lrx) {
                            graphics.setColor(Color.lightGray);
                            graphics.drawLine(xCoord1, this._uly + 1, xCoord1, this._lry - 1);
                            graphics.setColor(this._foreground);
                        }
                        xpos2 = this._gridStep(unlabeledgrid, xpos2, tmpStep, this._xlog);
                    }
                }
                if (needExponent) {
                    this._xExp = (int)Math.floor(xTmpStart);
                    graphics.setFont(this._superscriptfont);
                    graphics.drawString(Integer.toString(this._xExp), xSPos, ySPos - halflabelheight);
                    graphics.setFont(this._labelfont);
                    graphics.drawString("x10", xSPos -= this._labelFontMetrics.stringWidth("x10"), ySPos);
                } else {
                    this._xExp = 0;
                }
            }
        } else {
            Enumeration nt = this._xticks.elements();
            Enumeration nl = this._xticklabels.elements();
            while (nl.hasMoreElements()) {
                String label = (String)nl.nextElement();
                double xpos = (Double)nt.nextElement();
                if (xpos > this._xMax || xpos < this._xMin) continue;
                xCoord1 = this._ulx + (int)((xpos - this._xMin) * this._xscale);
                graphics.drawLine(xCoord1, this._uly, xCoord1, yCoord1);
                graphics.drawLine(xCoord1, this._lry, xCoord1, yCoord2);
                if (this._grid && xCoord1 != this._ulx && xCoord1 != this._lrx) {
                    graphics.setColor(Color.lightGray);
                    graphics.drawLine(xCoord1, yCoord1, xCoord1, yCoord2);
                    graphics.setColor(this._foreground);
                }
                int labxpos = xCoord1 - this._labelFontMetrics.stringWidth(label) / 2;
                graphics.drawString(label, labxpos, this._lry + 3 + labelheight);
            }
        }
        graphics.setColor(this._foreground);
        if (this._title != null) {
            graphics.setFont(this._titlefont);
            int titlex = this._ulx + (width - this._titleFontMetrics.stringWidth(this._title)) / 2;
            graphics.drawString(this._title, titlex, titley);
        }
        graphics.setFont(this._labelfont);
        if (this._xlabel != null) {
            int labelx = this._ulx + (width - this._labelFontMetrics.stringWidth(this._xlabel)) / 2;
            graphics.drawString(this._xlabel, labelx, ySPos);
        }
        int charcenter = 2 + this._labelFontMetrics.stringWidth("W") / 2;
        int charheight = labelheight;
        if (this._ylabel != null) {
            int yl = this._ylabel.length();
            int starty = this._uly + (this._lry - this._uly) / 2 - yl * charheight / 2 + charheight;
            int i = 0;
            while (i < yl) {
                String nchar = this._ylabel.substring(i, i + 1);
                int cwidth = this._labelFontMetrics.stringWidth(nchar);
                graphics.drawString(nchar, charcenter - cwidth / 2, starty);
                starty += charheight;
                ++i;
            }
        }
    }

    protected void _drawPoint(Graphics graphics, int dataset, long xpos, long ypos, boolean clip) {
        boolean pointinside;
        boolean bl = pointinside = ypos <= (long)this._lry && ypos >= (long)this._uly && xpos <= (long)this._lrx && xpos >= (long)this._ulx;
        if (!pointinside && clip) {
            return;
        }
        graphics.fillRect((int)xpos - 6, (int)ypos - 6, 6, 6);
    }

    private String _formatLogNum(double num, int numfracdigits) {
        int exponent = (int)num;
        String results = exponent >= 0 && exponent < 10 ? "0" + exponent : (exponent < 0 && exponent > -10 ? "-0" + -exponent : Integer.toString(exponent));
        results = num >= 0.0 ? (num - (double)((int)num) < 0.001 ? "1e" + results : this._formatNum(Math.pow(10.0, num - (double)((int)num)), numfracdigits)) : (-num - (double)((int)(-num)) < 0.001 ? "1e" + results : this._formatNum(Math.pow(10.0, num - (double)((int)num)) * 10.0, numfracdigits));
        return results;
    }

    private String _formatNum(double num, int numfracdigits) {
        if (this._numberFormat == null) {
            this._numberFormat = NumberFormat.getInstance();
        }
        this._numberFormat.setMinimumFractionDigits(numfracdigits);
        this._numberFormat.setMaximumFractionDigits(numfracdigits);
        return this._numberFormat.format(num);
    }

    private Vector _gridInit(double low, double step, boolean labeled, Vector oldgrid) {
        Vector<Double> grid = new Vector<Double>(10);
        double ratio = Math.pow(10.0, step);
        int ngrid = 1;
        if (labeled) {
            if (ratio <= 3.5) {
                ngrid = ratio > 2.0 ? 2 : (ratio > 1.26 ? 5 : (ratio > 1.125 ? 10 : (int)Math.rint(1.0 / step)));
            }
        } else {
            ngrid = ratio > 10.0 ? 1 : (ratio > 3.0 ? 2 : (ratio > 2.0 ? 5 : (ratio > 1.125 ? 10 : 100)));
        }
        int oldgridi = 0;
        int i = 0;
        while (i < ngrid) {
            double gridval = (double)i / (double)ngrid * 10.0;
            double logval = _LOG10SCALE * Math.log(gridval);
            if (logval == Double.NEGATIVE_INFINITY) {
                logval = 0.0;
            }
            if (oldgrid != null && oldgridi < oldgrid.size()) {
                while (oldgridi < oldgrid.size() && (Double)oldgrid.elementAt(oldgridi) < logval) {
                    ++oldgridi;
                }
                if (oldgridi < oldgrid.size()) {
                    if (Math.abs((Double)oldgrid.elementAt(oldgridi) - logval) > 1.0E-5) {
                        grid.addElement(new Double(logval));
                    }
                } else {
                    grid.addElement(new Double(logval));
                }
            } else {
                grid.addElement(new Double(logval));
            }
            ++i;
        }
        this._gridCurJuke = 0;
        if (low == -0.0) {
            low = 0.0;
        }
        this._gridBase = Math.floor(low);
        double x = low - this._gridBase;
        this._gridCurJuke = -1;
        while (this._gridCurJuke + 1 < grid.size() && x >= (Double)grid.elementAt(this._gridCurJuke + 1)) {
            ++this._gridCurJuke;
        }
        return grid;
    }

    private double _gridRoundUp(Vector grid, double pos) {
        double x = pos - Math.floor(pos);
        int i = 0;
        while (i < grid.size() && x >= (Double)grid.elementAt(i)) {
            ++i;
        }
        if (i >= grid.size()) {
            return pos;
        }
        return Math.floor(pos) + (Double)grid.elementAt(i);
    }

    private double _gridStep(Vector grid, double pos, double step, boolean logflag) {
        if (logflag) {
            if (++this._gridCurJuke >= grid.size()) {
                this._gridCurJuke = 0;
                this._gridBase += Math.ceil(step);
            }
            if (this._gridCurJuke >= grid.size()) {
                return pos + step;
            }
            return this._gridBase + (Double)grid.elementAt(this._gridCurJuke);
        }
        return pos + step;
    }

    private void _measureFonts() {
        if (this._labelfont == null) {
            this._labelfont = new Font("Helvetica", 0, 12);
        }
        if (this._superscriptfont == null) {
            this._superscriptfont = new Font("Helvetica", 0, 9);
        }
        if (this._titlefont == null) {
            this._titlefont = new Font("Helvetica", 1, 14);
        }
        this._labelFontMetrics = this.getFontMetrics(this._labelfont);
        this._superscriptFontMetrics = this.getFontMetrics(this._superscriptfont);
        this._titleFontMetrics = this.getFontMetrics(this._titlefont);
    }

    private int _numFracDigits(double num) {
        int numdigits = 0;
        while (numdigits <= 15 && num != Math.floor(num)) {
            num *= 10.0;
            ++numdigits;
        }
        return numdigits;
    }

    private int _numIntDigits(double num) {
        int numdigits = 0;
        while (numdigits <= 15 && (double)((int)num) != 0.0) {
            num /= 10.0;
            ++numdigits;
        }
        return numdigits;
    }

    protected boolean _parseLine(String line) {
        String lcLine = new String(line.toLowerCase());
        if (lcLine.startsWith("#")) {
            return true;
        }
        if (lcLine.startsWith("titletext:")) {
            this.setTitle(line.substring(10).trim());
            return true;
        }
        if (lcLine.startsWith("xlabel:")) {
            this.setXLabel(line.substring(7).trim());
            return true;
        }
        if (lcLine.startsWith("ylabel:")) {
            this.setYLabel(line.substring(7).trim());
            return true;
        }
        if (lcLine.startsWith("xrange:")) {
            int comma = line.indexOf(",", 7);
            if (comma > 0) {
                String min = line.substring(7, comma).trim();
                String max = line.substring(comma + 1).trim();
                try {
                    Double dmin = new Double(min);
                    Double dmax = new Double(max);
                    this.setXRange(dmin, dmax);
                }
                catch (NumberFormatException numberFormatException) {}
            }
            return true;
        }
        if (lcLine.startsWith("yrange:")) {
            int comma = line.indexOf(",", 7);
            if (comma > 0) {
                String min = line.substring(7, comma).trim();
                String max = line.substring(comma + 1).trim();
                try {
                    Double dmin = new Double(min);
                    Double dmax = new Double(max);
                    this.setYRange(dmin, dmax);
                }
                catch (NumberFormatException numberFormatException) {}
            }
            return true;
        }
        if (lcLine.startsWith("xticks:")) {
            this._parsePairs(line.substring(7), true);
            return true;
        }
        if (lcLine.startsWith("yticks:")) {
            this._parsePairs(line.substring(7), false);
            return true;
        }
        if (lcLine.startsWith("xlog:")) {
            this._xlog = lcLine.indexOf("off", 5) < 0;
            return true;
        }
        if (lcLine.startsWith("ylog:")) {
            this._ylog = lcLine.indexOf("off", 5) < 0;
            return true;
        }
        if (lcLine.startsWith("grid:")) {
            this._grid = lcLine.indexOf("off", 5) < 0;
            return true;
        }
        if (lcLine.startsWith("color:")) {
            this._usecolor = lcLine.indexOf("off", 6) < 0;
            return true;
        }
        return false;
    }

    private void _parsePairs(String line, boolean xtick) {
        int start = 0;
        boolean cont = true;
        while (cont) {
            int comma = line.indexOf(",", start);
            String pair = null;
            if (comma > start) {
                pair = line.substring(start, comma).trim();
            } else {
                pair = line.substring(start).trim();
                cont = false;
            }
            int close = -1;
            int open = 0;
            if (pair.startsWith("\"")) {
                close = pair.indexOf("\"", 1);
                open = 1;
            } else {
                close = pair.indexOf(" ");
            }
            if (close > 0) {
                String label = pair.substring(open, close);
                String index = pair.substring(close + 1).trim();
                try {
                    double idx = Double.valueOf(index);
                    if (xtick) {
                        this.addXTick(label, idx);
                    } else {
                        this.addYTick(label, idx);
                    }
                }
                catch (NumberFormatException numberFormatException) {}
            }
            start = comma + 1;
            comma = line.indexOf(",", start);
        }
    }

    private double _roundUp(double val) {
        int exponent;
        if ((val *= Math.pow(10.0, -(exponent = (int)Math.floor(Math.log(val) * _LOG10SCALE)))) > 5.0) {
            val = 10.0;
        } else if (val > 2.0) {
            val = 5.0;
        } else if (val > 1.0) {
            val = 2.0;
        }
        return val *= Math.pow(10.0, exponent);
    }

    protected void _setButtonsVisibility(boolean vis) {
        this._fillButton.setVisible(vis);
    }

    private void _setXRange(double min, double max) {
        if (min > max) {
            min = -1.0;
            max = 1.0;
        } else if (min == max) {
            min -= 1.0;
            max += 1.0;
        }
        this._xMin = min - (max - min) * 0.05;
        this._xMax = max + (max - min) * 0.05;
        double largest = Math.max(Math.abs(this._xMin), Math.abs(this._xMax));
        this._xExp = (int)Math.floor(Math.log(largest) * _LOG10SCALE);
        if (this._xExp > 1 || this._xExp < -1) {
            double xs = 1.0 / Math.pow(10.0, this._xExp);
            this._xtickMin = this._xMin * xs;
            this._xtickMax = this._xMax * xs;
        } else {
            this._xtickMin = this._xMin;
            this._xtickMax = this._xMax;
            this._xExp = 0;
        }
    }

    private void _setYRange(double min, double max) {
        if (min > max) {
            min = -1.0;
            max = 1.0;
        } else if (min == max) {
            min -= 0.1;
            max += 0.1;
        }
        this._yMin = min - (max - min) * 0.05;
        this._yMax = max + (max - min) * 0.05;
        double largest = Math.max(Math.abs(this._yMin), Math.abs(this._yMax));
        this._yExp = (int)Math.floor(Math.log(largest) * _LOG10SCALE);
        if (this._yExp > 1 || this._yExp < -1) {
            double ys = 1.0 / Math.pow(10.0, this._yExp);
            this._ytickMin = this._yMin * ys;
            this._ytickMax = this._yMax * ys;
        } else {
            this._ytickMin = this._yMin;
            this._ytickMax = this._yMax;
            this._yExp = 0;
        }
    }

    protected void _write(PrintWriter output) {
        int i;
        int last;
        output.println("# Ptolemy plot, version 2.0");
        if (this._title != null) {
            output.println("TitleText: " + this._title);
        }
        if (this._xlabel != null) {
            output.println("XLabel: " + this._xlabel);
        }
        if (this._ylabel != null) {
            output.println("YLabel: " + this._ylabel);
        }
        if (this._xRangeGiven) {
            output.println("XRange: " + this._xlowgiven + ", " + this._xhighgiven);
        }
        if (this._yRangeGiven) {
            output.println("YRange: " + this._ylowgiven + ", " + this._yhighgiven);
        }
        if (this._xticks != null && this._xticks.size() > 0) {
            output.print("XTicks: ");
            last = this._xticks.size() - 1;
            i = 0;
            while (i < last) {
                output.print("\"" + (String)this._xticklabels.elementAt(i) + "\" " + (Double)this._xticks.elementAt(i) + ", ");
                ++i;
            }
            output.println("\"" + (String)this._xticklabels.elementAt(last) + "\" " + (Double)this._xticks.elementAt(last));
        }
        if (this._yticks != null && this._yticks.size() > 0) {
            output.print("YTicks: ");
            last = this._yticks.size() - 1;
            i = 0;
            while (i < last) {
                output.print("\"" + (String)this._yticklabels.elementAt(i) + "\" " + (Double)this._yticks.elementAt(i) + ", ");
                ++i;
            }
            output.println("\"" + (String)this._yticklabels.elementAt(last) + "\" " + (Double)this._yticks.elementAt(last));
        }
        if (this._xlog) {
            output.println("XLog: on");
        }
        if (this._ylog) {
            output.println("YLog: on");
        }
        if (!this._grid) {
            output.println("Grid: off");
        }
        if (!this._usecolor) {
            output.println("Color: off");
        }
    }

    public synchronized void _zoom(int x, int y) {
        Graphics graphics = this.getGraphics();
        boolean handled = false;
        if (this._zoomin && this._drawn) {
            if (this._zoomxn != -1 || this._zoomyn != -1) {
                int minx = Math.min(this._zoomx, this._zoomxn);
                int maxx = Math.max(this._zoomx, this._zoomxn);
                int miny = Math.min(this._zoomy, this._zoomyn);
                int maxy = Math.max(this._zoomy, this._zoomyn);
                graphics.setXORMode(this._background);
                graphics.drawRect(minx, miny, maxx - minx, maxy - miny);
                graphics.setPaintMode();
                if (y > this._lry) {
                    y = this._lry;
                }
                if (y < this._uly) {
                    y = this._uly;
                }
                if (x > this._lrx) {
                    x = this._lrx;
                }
                if (x < this._ulx) {
                    x = this._ulx;
                }
                if (Math.abs(this._zoomx - x) > 5 && Math.abs(this._zoomy - y) > 5) {
                    double a = this._xMin + (double)(this._zoomx - this._ulx) / this._xscale;
                    double b = this._xMin + (double)(x - this._ulx) / this._xscale;
                    if (a < b) {
                        this.setXRange(a, b);
                    } else {
                        this.setXRange(b, a);
                    }
                    a = this._yMax - (double)(this._zoomy - this._uly) / this._yscale;
                    b = this._yMax - (double)(y - this._uly) / this._yscale;
                    if (a < b) {
                        this.setYRange(a, b);
                    } else {
                        this.setYRange(b, a);
                    }
                }
                this.repaint();
                handled = true;
            }
        } else if (this._zoomout && this._drawn) {
            graphics.setXORMode(this._background);
            int x_diff = Math.abs(this._zoomx - this._zoomxn);
            int y_diff = Math.abs(this._zoomy - this._zoomyn);
            graphics.drawRect(this._zoomx - 15 - x_diff, this._zoomy - 15 - y_diff, 30 + x_diff * 2, 30 + y_diff * 2);
            graphics.setPaintMode();
            double a = (double)Math.abs(this._zoomx - x) / 30.0;
            double b = (double)Math.abs(this._zoomy - y) / 30.0;
            double newx1 = this._xMax + (this._xMax - this._xMin) * a;
            double newx2 = this._xMin - (this._xMax - this._xMin) * a;
            double newy1 = this._yMax + (this._yMax - this._yMin) * b;
            double newy2 = this._yMin - (this._yMax - this._yMin) * b;
            this.zoom(newx2, newy2, newx1, newy1);
            handled = true;
        } else if (!this._drawn) {
            this.repaint();
            handled = true;
        }
        this._drawn = false;
        this._zoomout = false;
        this._zoomin = false;
        this._zoomy = -1;
        this._zoomx = -1;
        this._zoomyn = -1;
        this._zoomxn = -1;
    }

    public synchronized void _zoomBox(int x, int y) {
        Graphics graphics = this.getGraphics();
        if (y > this._lry) {
            y = this._lry;
        }
        if (y < this._uly) {
            y = this._uly;
        }
        if (x > this._lrx) {
            x = this._lrx;
        }
        if (x < this._ulx) {
            x = this._ulx;
        }
        if (this._zoomx != -1 || this._zoomy != -1) {
            if (!this._zoomin && !this._zoomout) {
                if (y < this._zoomy) {
                    this._zoomout = true;
                    graphics.drawRect(this._zoomx - 15, this._zoomy - 15, 30, 30);
                } else if (y > this._zoomy) {
                    this._zoomin = true;
                }
            }
            if (this._zoomin) {
                int maxy;
                int miny;
                int maxx;
                int minx;
                graphics.setXORMode(this._background);
                if ((this._zoomxn != -1 || this._zoomyn != -1) && this._drawn) {
                    minx = Math.min(this._zoomx, this._zoomxn);
                    maxx = Math.max(this._zoomx, this._zoomxn);
                    miny = Math.min(this._zoomy, this._zoomyn);
                    maxy = Math.max(this._zoomy, this._zoomyn);
                    graphics.drawRect(minx, miny, maxx - minx, maxy - miny);
                }
                if (y > this._zoomy) {
                    this._zoomxn = x;
                    this._zoomyn = y;
                    minx = Math.min(this._zoomx, this._zoomxn);
                    maxx = Math.max(this._zoomx, this._zoomxn);
                    miny = Math.min(this._zoomy, this._zoomyn);
                    maxy = Math.max(this._zoomy, this._zoomyn);
                    graphics.drawRect(minx, miny, maxx - minx, maxy - miny);
                    graphics.setPaintMode();
                    this._drawn = true;
                    return;
                }
                this._drawn = false;
            } else if (this._zoomout) {
                int y_diff;
                int x_diff;
                graphics.setXORMode(this._background);
                if ((this._zoomxn != -1 || this._zoomyn != -1) && this._drawn) {
                    x_diff = Math.abs(this._zoomx - this._zoomxn);
                    y_diff = Math.abs(this._zoomy - this._zoomyn);
                    graphics.drawRect(this._zoomx - 15 - x_diff, this._zoomy - 15 - y_diff, 30 + x_diff * 2, 30 + y_diff * 2);
                }
                if (y < this._zoomy) {
                    this._zoomxn = x;
                    this._zoomyn = y;
                    x_diff = Math.abs(this._zoomx - this._zoomxn);
                    y_diff = Math.abs(this._zoomy - this._zoomyn);
                    graphics.drawRect(this._zoomx - 15 - x_diff, this._zoomy - 15 - y_diff, 30 + x_diff * 2, 30 + y_diff * 2);
                    graphics.setPaintMode();
                    this._drawn = true;
                    return;
                }
                this._drawn = false;
            }
        }
        graphics.setPaintMode();
    }

    public synchronized void _zoomStart(int x, int y) {
        if (y > this._lry) {
            y = this._lry;
        }
        if (y < this._uly) {
            y = this._uly;
        }
        if (x > this._lrx) {
            x = this._lrx;
        }
        if (x < this._ulx) {
            x = this._ulx;
        }
        this._zoomx = x;
        this._zoomy = y;
    }

    public void addLegend(int dataset, String legend) {
        this._legendStrings.addElement(legend);
        this._legendDatasets.addElement(new Integer(dataset));
    }

    public void addXTick(String label, double position) {
        if (this._xticks == null) {
            this._xticks = new Vector();
            this._xticklabels = new Vector();
        }
        this._xticks.addElement(new Double(position));
        this._xticklabels.addElement(label);
    }

    public void addYTick(String label, double position) {
        if (this._yticks == null) {
            this._yticks = new Vector();
            this._yticklabels = new Vector();
        }
        this._yticks.addElement(new Double(position));
        this._yticklabels.addElement(label);
    }

    public synchronized void clear(boolean axes) {
        this._xBottom = Double.MAX_VALUE;
        this._xTop = -1.7976931348623157E308;
        this._yBottom = Double.MAX_VALUE;
        this._yTop = -1.7976931348623157E308;
        if (axes) {
            this._yMax = 0.0;
            this._yMin = 0.0;
            this._xMax = 0.0;
            this._xMin = 0.0;
            this._xRangeGiven = false;
            this._yRangeGiven = false;
            this._xlog = false;
            this._ylog = false;
            this._grid = true;
            this._usecolor = true;
            this._filespec = null;
            this._xlabel = null;
            this._ylabel = null;
            this._title = null;
            this._legendStrings = new Vector();
            this._legendDatasets = new Vector();
            this._xticks = null;
            this._xticklabels = null;
            this._yticks = null;
            this._yticklabels = null;
        }
    }

    public synchronized void fillPlot() {
        this._setXRange(this._xBottom, this._xTop);
        this._setYRange(this._yBottom, this._yTop);
        this.repaint();
    }

    /*
     * Unable to fully structure code
     */
    public static Color getColorByName(String name) {
        try {
            col = new Color(Integer.parseInt(name, 16));
            return col;
        }
        catch (NumberFormatException v0) {
            names = new String[][]{{"black", "00000"}, {"white", "ffffff"}, {"red", "ff0000"}, {"green", "00ff00"}, {"blue", "0000ff"}};
            i = 0;
            ** while (i < names.length)
        }
lbl-1000:
        // 1 sources

        {
            if (name.equals(names[i][0])) {
                try {
                    col = new Color(Integer.parseInt(names[i][1], 16));
                    return col;
                }
                catch (NumberFormatException v1) {}
            }
            ++i;
            continue;
        }
lbl15:
        // 1 sources

        return null;
    }

    public String getDataurl() {
        return this._filespec;
    }

    public URL getDocumentBase() {
        return this._documentBase;
    }

    public String getLegend(int dataset) {
        int idx = this._legendDatasets.indexOf(new Integer(dataset), 0);
        if (idx != -1) {
            return (String)this._legendStrings.elementAt(idx);
        }
        return null;
    }

    public Dimension getMinimumSize() {
        return new Dimension(this._width, this._height);
    }

    public Dimension getPreferredSize() {
        return new Dimension(this._width, this._height);
    }

    public void init() {
        this.setButtons(true);
        if (this._filespec != null) {
            this.parseFile(this._filespec, this._documentBase);
        }
    }

    public boolean isDoYTicks() {
        return this.doYTicks;
    }

    public void paint(Graphics graphics) {
        this._drawPlot(graphics, true);
    }

    public void parseFile(String filespec) {
        this.parseFile(filespec, null);
    }

    public void parseFile(String filespec, URL documentBase) {
        DataInputStream in = null;
        if (filespec == null || filespec.length() == 0) {
            in = new DataInputStream(System.in);
        } else {
            try {
                URL url = null;
                if (documentBase == null && this._documentBase != null) {
                    documentBase = this._documentBase;
                }
                if (documentBase == null) {
                    url = new URL(filespec);
                } else {
                    try {
                        url = new URL(documentBase, filespec);
                    }
                    catch (NullPointerException nullPointerException) {
                        url = new URL(filespec);
                    }
                }
                in = new DataInputStream(url.openStream());
            }
            catch (MalformedURLException malformedURLException) {
                try {
                    in = new DataInputStream(new FileInputStream(filespec));
                }
                catch (FileNotFoundException me) {
                    this._errorMsg = new String[2];
                    this._errorMsg[0] = "File not found: " + filespec;
                    this._errorMsg[1] = me.getMessage();
                    return;
                }
                catch (SecurityException me) {
                    this._errorMsg = new String[2];
                    this._errorMsg[0] = "Security Exception: " + filespec;
                    this._errorMsg[1] = me.getMessage();
                    return;
                }
            }
            catch (IOException ioe) {
                this._errorMsg = new String[3];
                this._errorMsg[0] = "Failure opening URL: ";
                this._errorMsg[1] = " " + filespec;
                this._errorMsg[2] = ioe.getMessage();
                return;
            }
        }
        try {
            try {
                BufferedReader din = new BufferedReader(new InputStreamReader(in));
                String line = din.readLine();
                while (line != null) {
                    this._parseLine(line);
                    line = din.readLine();
                }
            }
            catch (MalformedURLException e) {
                this._errorMsg = new String[2];
                this._errorMsg[0] = "Malformed URL: " + filespec;
                this._errorMsg[1] = e.getMessage();
                Object var5_13 = null;
                try {
                    in.close();
                }
                catch (IOException iOException) {}
                return;
            }
            catch (IOException e) {
                this._errorMsg = new String[2];
                this._errorMsg[0] = "Failure reading data: " + filespec;
                this._errorMsg[1] = e.getMessage();
                this._errorMsg[1] = e.getMessage();
            }
            Object var5_14 = null;
        }
        catch (Throwable throwable) {
            Object var5_15 = null;
            try {
                in.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            in.close();
        }
        catch (IOException iOException) {}
    }

    /*
     * WARNING - void declaration
     */
    public void read(InputStream in) throws IOException {
        try {
            BufferedReader din = new BufferedReader(new InputStreamReader(in));
            try {
                String line = din.readLine();
                while (line != null) {
                    this._parseLine(line);
                    line = din.readLine();
                }
            }
            finally {
                Object var4_5 = null;
                din.close();
            }
        }
        catch (IOException e) {
            void din;
            this._errorMsg = new String[2];
            this._errorMsg[0] = "Failure reading input data.";
            this._errorMsg[1] = e.getMessage();
            throw din;
        }
    }

    public void setBackground(Color background) {
        this._background = background;
        super.setBackground(this._background);
    }

    public void setBinary(boolean binary) {
        this._binary = binary;
    }

    public void setBounds(int x, int y, int width, int height) {
        this._width = width;
        this._height = height;
        super.setBounds(x, y, this._width, this._height);
    }

    public void setButtons(boolean visible) {
        if (this._fillButton == null) {
            this._fillButton = new Button("fill");
            this._fillButton.addActionListener(new FillButtonListener());
            this.add(this._fillButton);
        }
        this._fillButton.setVisible(visible);
    }

    public void setDataurl(String filespec) {
        this._filespec = filespec;
    }

    public void setDoYTicks(boolean b) {
        this.doYTicks = b;
    }

    public void setDocumentBase(URL documentBase) {
        this._documentBase = documentBase;
    }

    public void setForeground(Color foreground) {
        this._foreground = foreground;
        super.setForeground(this._foreground);
    }

    public void setGrid(boolean grid) {
        this._grid = grid;
    }

    public void setLabelFont(String name) {
        this._labelfont = Font.decode(name);
    }

    public void setSize(int width, int height) {
        this._width = width;
        this._height = height;
        super.setSize(width, height);
    }

    public void setTitle(String title) {
        this._title = title;
    }

    public void setTitleFont(String name) {
        this._titlefont = Font.decode(name);
        this._titleFontMetrics = this.getFontMetrics(this._titlefont);
    }

    public void setXLabel(String label) {
        this._xlabel = label;
    }

    public void setXLog(boolean xlog) {
        this._xlog = xlog;
    }

    public void setXRange(double min, double max) {
        this._xRangeGiven = true;
        this._xlowgiven = min;
        this._xhighgiven = max;
        this._setXRange(min, max);
    }

    public void setYLabel(String label) {
        this._ylabel = label;
    }

    public void setYLog(boolean ylog) {
        this._ylog = ylog;
    }

    public void setYRange(double min, double max) {
        this._yRangeGiven = true;
        this._ylowgiven = min;
        this._yhighgiven = max;
        this._setYRange(min, max);
    }

    public void write(OutputStream out) {
        PrintWriter output = new PrintWriter(new BufferedOutputStream(out), false);
        this._write(output);
        output.flush();
        output.close();
    }

    public synchronized void zoom(double lowx, double lowy, double highx, double highy) {
        this.setXRange(lowx, highx);
        this.setYRange(lowy, highy);
        this.repaint();
    }

    class FillButtonListener
    implements ActionListener {
        FillButtonListener() {
            PlotBox.this = PlotBox.this;
        }

        public void actionPerformed(ActionEvent event) {
            PlotBox.this.fillPlot();
        }
    }

    public class ZoomListener
    implements MouseListener {
        public ZoomListener() {
            PlotBox.this = PlotBox.this;
        }

        public void mouseClicked(MouseEvent event) {
        }

        public void mouseEntered(MouseEvent event) {
        }

        public void mouseExited(MouseEvent event) {
        }

        public void mousePressed(MouseEvent event) {
            PlotBox.this._zoomStart(event.getX(), event.getY());
        }

        public void mouseReleased(MouseEvent event) {
            PlotBox.this._zoom(event.getX(), event.getY());
        }
    }

    public class DragListener
    implements MouseMotionListener {
        public DragListener() {
            PlotBox.this = PlotBox.this;
        }

        public void mouseDragged(MouseEvent event) {
            PlotBox.this._zoomBox(event.getX(), event.getY());
        }

        public void mouseMoved(MouseEvent event) {
        }
    }
}

