/*
 * Decompiled with CFR 0.152.
 */
package montecarlo;

import montecarlo.Function;
import ptolemy.plot.Plot;

public class PolarPlot
extends Plot {
    private int nTheta = 1000;
    private double thetaMin;
    private double thetaMax = Math.PI * 2;
    private double dTheta;
    private Function radius = new 1();
    private double X;
    private double Y;
    private boolean fixedRange = false;

    public PolarPlot() {
        this.setTitle("Polar Plot");
        this.setYRange(-0.5, 0.5);
        this.setXRange(-0.5, 0.5);
        this.setNTheta(1000);
        this.setConnected(true);
    }

    public void display() {
        this.clear(false);
        this.repaint();
        int i = 0;
        while (i < this.nTheta) {
            double theta = this.thetaMin + (double)i * this.dTheta;
            this.setXY(theta);
            this.addPoint(0, this.X, this.Y, i > 0);
            ++i;
        }
        if (!this.fixedRange) {
            this.fillPlot();
        }
    }

    public Function getFunction() {
        return this.radius;
    }

    public int getNTheta() {
        return this.nTheta;
    }

    public void setFunction(Function func) {
        this.radius = func;
    }

    public void setNTheta(int n) {
        if (this.nTheta < 2) {
            this.nTheta = 2;
        }
        this.nTheta = n;
        this.dTheta = (this.thetaMax - this.thetaMin) / (double)(this.nTheta - 1);
    }

    public void setRange(double xmin, double xmax, double ymin, double ymax) {
        this.setXRange(xmin, xmax);
        this.setYRange(ymin, ymax);
        this.fixedRange = true;
    }

    private void setXY(double theta) {
        double r = this.radius.f(theta);
        this.X = r * Math.cos(theta);
        this.Y = r * Math.sin(theta);
    }

    public void unsetRange() {
        this.fixedRange = false;
    }

    private final class 1
    implements Function {
        /* synthetic */ 1() {
        }

        public double f(double x) {
            return 1.0;
        }
    }
}

