/*
 * Decompiled with CFR 0.152.
 */
package montecarlo;

import java.util.Random;
import montecarlo.MultiVariateFunction;
import montecarlo.MyRandom;

public class MultiVariateQuadrature {
    private MultiVariateFunction integrand;
    private double[] xMin;
    private double[] xMax;
    private double[][] x;
    private double[] X;
    private int nPoints;
    private int nPointsD;
    private int jPoint;

    public MultiVariateQuadrature(MultiVariateFunction i) {
        this.setFunction(i);
        this.setN(20);
        this.setXMin(0.0);
        this.setXMax(1.0);
    }

    public int getN() {
        return this.nPoints;
    }

    public double[][] getX() {
        return this.x;
    }

    public double getXMax() {
        return this.xMax[0];
    }

    public double getXMin() {
        return this.xMin[0];
    }

    public double givenPoints(double[][] points) {
        double sum = 0.0;
        int i = 0;
        while (i < points.length) {
            sum += this.integrand.f(points[i]);
            ++i;
        }
        double volume = 1.0;
        int k = 0;
        while (k < this.integrand.D()) {
            volume *= this.xMax[k] - this.xMin[k];
            ++k;
        }
        return sum * volume / (double)points.length;
    }

    public double rectangle() {
        this.jPoint = 0;
        return this.rectangleRecurse(0);
    }

    public double rectangle(int n) {
        this.setN(n);
        return this.rectangle();
    }

    private double rectangleRecurse(int k) {
        double deltaX = (this.xMax[k] - this.xMin[k]) / (double)this.nPointsD;
        double sum = 0.0;
        int i = 0;
        while (i < this.nPointsD) {
            this.X[k] = this.xMin[k] + ((double)i + 0.5) * deltaX;
            if (k == this.integrand.D() - 1) {
                sum += this.integrand.f(this.X);
                int m = 0;
                while (m <= k) {
                    this.x[this.jPoint][m] = this.X[m];
                    ++m;
                }
                ++this.jPoint;
            } else {
                sum += this.rectangleRecurse(k + 1);
            }
            ++i;
        }
        return sum * deltaX;
    }

    public void setFunction(MultiVariateFunction i) {
        this.integrand = i;
        this.setN(this.nPoints);
    }

    public void setN(int n) {
        this.nPointsD = (int)Math.pow(n, 1.0 / (double)this.integrand.D());
        this.nPoints = (int)Math.pow(this.nPointsD, this.integrand.D());
        System.out.println(String.valueOf(n) + " " + this.nPointsD + " " + this.nPoints);
        this.x = new double[this.nPoints][this.integrand.D()];
        this.X = new double[this.integrand.D()];
    }

    public void setXMax(double xmax) {
        this.xMax = new double[this.x[0].length];
        int i = 0;
        while (i < this.x[0].length) {
            this.xMax[i] = xmax;
            ++i;
        }
    }

    public void setXMin(double xmin) {
        this.xMin = new double[this.integrand.D()];
        int i = 0;
        while (i < this.x[0].length) {
            this.xMin[i] = xmin;
            ++i;
        }
    }

    public double simpleMC() {
        MyRandom rand = new MyRandom();
        double sum = 0.0;
        int i = 0;
        while (i < this.nPoints) {
            int k = 0;
            while (k < this.integrand.D()) {
                this.x[i][k] = this.xMin[k] + (this.xMax[k] - this.xMin[k]) * ((Random)rand).nextDouble();
                ++k;
            }
            sum += this.integrand.f(this.x[i]);
            ++i;
        }
        double volume = 1.0;
        int k = 0;
        while (k < this.integrand.D()) {
            volume *= this.xMax[k] - this.xMin[k];
            ++k;
        }
        return sum * volume / (double)this.nPoints;
    }

    public double simpleMC(int n) {
        this.setN(n);
        return this.simpleMC();
    }
}

