/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import montecarlo.Function;
import montecarlo.MultiVariateFunction;
import montecarlo.MultiVariateQuadrature;
import montecarlo.PolarPlot;
import symantec.itools.lang.Context;

public class MCApplet2D1
extends Applet {
    Panel panel1 = new Panel();
    Label label1 = new Label();
    TextField inputField = new TextField();
    Button button1 = new Button();
    Button button2 = new Button();
    TextField resultField = new TextField();
    TextField errorField = new TextField();
    Label label2 = new Label();
    Label label3 = new Label();
    Panel panel2 = new Panel();
    Panel titlePanel = new Panel();
    Label title = new Label();
    Label label4 = new Label();
    PolarPlot points = new PolarPlot();
    int nPoints = 100;
    MultiVariateQuadrature quad = new MultiVariateQuadrature(new 2());
    MultiVariateQuadrature norm = new MultiVariateQuadrature(new 3());

    void button1_ActionPerformed(ActionEvent event) {
        this.button1_ActionPerformed_Interaction1(event);
    }

    void button1_ActionPerformed_Interaction1(ActionEvent event) {
        try {
            this.quadRectangle();
        }
        catch (Exception exception) {}
    }

    void button2_ActionPerformed(ActionEvent event) {
        this.button2_ActionPerformed_Interaction1(event);
    }

    void button2_ActionPerformed_Interaction1(ActionEvent event) {
        try {
            this.quadMC();
        }
        catch (Exception exception) {}
    }

    private double exact() {
        return 0.061764770000000004;
    }

    public int getNPoints() {
        return this.nPoints;
    }

    public void init() {
        Context.setApplet(this);
        this.setLayout(null);
        this.setBackground(new Color(153, 153, 102));
        this.setSize(723, 522);
        this.panel1.setLayout(null);
        this.add(this.panel1);
        this.panel1.setBounds(36, 96, 204, 252);
        this.label1.setText("No. of quadrature points");
        this.panel1.add(this.label1);
        this.label1.setForeground(Color.black);
        this.label1.setBounds(0, 12, 132, 24);
        this.panel1.add(this.inputField);
        ((Component)this.inputField).setBackground(new Color(153, 153, 102));
        this.inputField.setBounds(144, 12, 60, 24);
        this.button1.setLabel("Do rectangle-rule quadrature");
        this.panel1.add(this.button1);
        this.button1.setBackground(new Color(204, 204, 153));
        this.button1.setForeground(Color.black);
        this.button1.setBounds(0, 60, 197, 37);
        this.button2.setLabel("Do Monte Carlo quadrature");
        this.panel1.add(this.button2);
        this.button2.setBackground(new Color(204, 204, 153));
        this.button2.setForeground(Color.black);
        this.button2.setBounds(0, 108, 197, 37);
        this.resultField.setEditable(false);
        this.panel1.add(this.resultField);
        ((Component)this.resultField).setBackground(new Color(204, 204, 153));
        this.resultField.setBounds(84, 168, 120, 24);
        this.errorField.setEditable(false);
        this.panel1.add(this.errorField);
        ((Component)this.errorField).setBackground(new Color(204, 204, 153));
        this.errorField.setBounds(84, 204, 120, 24);
        this.label2.setText("Result");
        this.label2.setAlignment(2);
        this.panel1.add(this.label2);
        this.label2.setBounds(0, 168, 72, 24);
        this.label3.setText("Error");
        this.label3.setAlignment(2);
        this.panel1.add(this.label3);
        this.label3.setBounds(0, 204, 72, 24);
        this.panel2.setLayout(new GridLayout(1, 1, 0, 0));
        this.add(this.panel2);
        this.panel2.setBackground(new Color(153, 102, 102));
        this.panel2.setBounds(276, 108, 400, 400);
        this.titlePanel.setLayout(new GridLayout(2, 1, 0, 0));
        this.add(this.titlePanel);
        this.titlePanel.setBounds(50, 24, 600, 72);
        this.title.setText("Two-Dimensional Monte Carlo Quadrature");
        this.title.setAlignment(1);
        this.titlePanel.add(this.title);
        this.title.setForeground(new Color(153, 0, 0));
        this.title.setFont(new Font("Dialog", 1, 18));
        this.title.setBounds(0, 0, 600, 36);
        this.label4.setText("evaluating the mean square distance from origin for enclosed region shown");
        this.label4.setAlignment(1);
        this.titlePanel.add(this.label4);
        this.label4.setBounds(0, 36, 600, 36);
        SymText lSymText = new SymText();
        this.inputField.addTextListener(lSymText);
        SymAction lSymAction = new SymAction();
        this.button1.addActionListener(lSymAction);
        this.button2.addActionListener(lSymAction);
        this.quad.setXMin(-0.5);
        this.quad.setXMax(0.5);
        this.norm.setXMin(-0.5);
        this.norm.setXMax(0.5);
        this.points.setTitle("Quadrature points");
        this.panel2.add(this.points);
        this.setNPoints(100);
        ((TextComponent)this.inputField).setText(new Integer(this.nPoints).toString());
        this.points.setRange(-0.5, 0.5, -0.5, 0.5);
        this.points.setNTheta(1000);
        this.points.setMarksStyle("points", 1);
        this.points.setFunction(new 1());
        this.points.display();
    }

    void inputField_TextValueChanged(TextEvent event) {
        this.inputField_TextValueChanged_Interaction1(event);
    }

    void inputField_TextValueChanged_Interaction1(TextEvent event) {
        try {
            int nNew = Integer.parseInt(this.inputField.getText());
            int nMax = 10000;
            if (nNew <= nMax) {
                this.setNPoints(nNew);
            } else {
                ((TextComponent)this.inputField).setText(new Integer(nMax).toString());
                this.setNPoints(nMax);
            }
        }
        catch (Exception exception) {}
    }

    public void quadMC() {
        double numerator = this.quad.simpleMC(this.nPoints);
        double denominator = this.norm.givenPoints(this.quad.getX());
        this.writeResult(numerator / denominator);
    }

    public void quadRectangle() {
        double numerator = this.quad.rectangle(this.nPoints);
        double denominator = this.norm.givenPoints(this.quad.getX());
        this.writeResult(numerator / denominator);
    }

    public void setNPoints(int n) {
        this.nPoints = n;
    }

    private void writeResult(double q) {
        ((TextComponent)this.resultField).setText(new Float(q).toString());
        ((TextComponent)this.errorField).setText(new Float(q - this.exact()).toString());
        this.points.display();
        int i = 0;
        while (i < this.quad.getX().length) {
            this.points.addPoint(1, this.quad.getX()[i][0], this.quad.getX()[i][1], false);
            ++i;
        }
        this.repaint();
    }

    private final class 1
    implements Function {
        /* synthetic */ 1() {
        }

        public double f(double t) {
            return 0.09 + 0.45 * Math.exp(-t * 0.25) * Math.pow(Math.sin(5.0 * t), 2.0) * (1.0 + Math.cos(2.5 * (t - 1.0))) * 0.7000000000000001;
        }
    }

    private final class 2
    implements MultiVariateFunction {
        /* synthetic */ 2() {
        }

        public int D() {
            return 2;
        }

        public double f(double[] x) {
            double X = x[0];
            double Y = x[1];
            double r2 = X * X + Y * Y;
            double theta = Math.atan2(X, Y) + Math.PI;
            double radius = MCApplet2D1.this.points.getFunction().f(theta);
            return r2 < radius * radius ? r2 : 0.0;
        }
    }

    private final class 3
    implements MultiVariateFunction {
        /* synthetic */ 3() {
        }

        public int D() {
            return 2;
        }

        public double f(double[] x) {
            double X = x[0];
            double Y = x[1];
            double r2 = X * X + Y * Y;
            double theta = Math.atan2(X, Y) + Math.PI;
            double radius = MCApplet2D1.this.points.getFunction().f(theta);
            return r2 < radius * radius ? 1.0 : 0.0;
        }
    }

    class SymText
    implements TextListener {
        SymText() {
            MCApplet2D1.this = MCApplet2D1.this;
        }

        public void textValueChanged(TextEvent event) {
            Object object = event.getSource();
            if (object == MCApplet2D1.this.inputField) {
                MCApplet2D1.this.inputField_TextValueChanged(event);
            }
        }
    }

    class SymAction
    implements ActionListener {
        SymAction() {
            MCApplet2D1.this = MCApplet2D1.this;
        }

        public void actionPerformed(ActionEvent event) {
            Object object = event.getSource();
            if (object == MCApplet2D1.this.button1) {
                MCApplet2D1.this.button1_ActionPerformed(event);
            } else if (object == MCApplet2D1.this.button2) {
                MCApplet2D1.this.button2_ActionPerformed(event);
            }
        }
    }
}

